/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.dnd.java;

import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.java.UMLJavaUtils;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class ClassModelConverter
implements CreationFactory {
    protected IType type;

    public ClassModelConverter(IType type) {
        this.type = type;
    }

    public Object getNewObject() {
        try {
            InterfaceModel rv = null;
            if (this.type.isInterface()) {
                rv = new InterfaceModel();
                rv.setName(this.type.getFullyQualifiedName());
            } else if (this.type.isClass()) {
                rv = new ClassModel();
                ((ClassModel)rv).setName(this.type.getFullyQualifiedName());
            }
            AttributeModel[] fields = UMLJavaUtils.getFields(this.type);
            int i = 0;
            while (i < fields.length) {
                rv.addChild((AbstractUMLModel)fields[i]);
                ++i;
            }
            OperationModel[] methods = UMLJavaUtils.getMethods(this.type);
            int i2 = 0;
            while (i2 < methods.length) {
                rv.addChild((AbstractUMLModel)methods[i2]);
                ++i2;
            }
            return rv;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getObjectType() {
        try {
            if (this.type.isInterface()) {
                return InterfaceModel.class;
            }
            return ClassModel.class;
        }
        catch (Exception exception) {
            return ClassModel.class;
        }
    }
}

