/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.java.UMLJavaUtils;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ImportClassModelCommand
extends Command {
    private IType[] types;
    private RootModel root;
    private List<AbstractUMLEntityModel> models;
    private Point location;

    public ImportClassModelCommand(RootModel root, IType type) {
        this(root, new IType[]{type});
    }

    public ImportClassModelCommand(RootModel root, IType[] types) {
        this.root = root;
        this.types = types;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    public void execute() {
        this.models = new ArrayList<AbstractUMLEntityModel>();
        ArrayList<AbstractUMLEntityModel> addedModels = new ArrayList<AbstractUMLEntityModel>();
        int i = 0;
        while (i < this.types.length) {
            AbstractUMLEntityModel entity = this.createModel(this.types[i]);
            addedModels.add(entity);
            if (entity != null) {
                if (this.location != null) {
                    entity.setConstraint(new Rectangle(this.location.x + i * 10, this.location.y + i * 10, -1, -1));
                } else {
                    entity.setConstraint(new Rectangle(10, 10, -1, -1));
                }
                this.root.copyPresentation((AbstractUMLModel)entity);
                this.root.addChild((AbstractUMLModel)entity);
                this.models.add(entity);
            }
            ++i;
        }
        this.addConnections(addedModels);
    }

    private void addConnections(List<AbstractUMLEntityModel> addedModels) {
        try {
            int i = 0;
            while (i < addedModels.size()) {
                AbstractUMLEntityModel model = addedModels.get(i);
                if (this.types[i].isInterface()) {
                    UMLJavaUtils.appendInterfacesConnection(this.root, this.types[i], model);
                } else {
                    UMLJavaUtils.appendSuperClassConnection(this.root, this.types[i], model);
                    UMLJavaUtils.appendInterfacesConnection(this.root, this.types[i], model);
                    UMLJavaUtils.appendAggregationConnection(this.root, this.types[i], (ClassModel)model);
                }
                UMLJavaUtils.appendSubConnection(this.root, this.types[i].getJavaProject(), model);
                ++i;
            }
        }
        catch (JavaModelException ex) {
            UMLPlugin.logException((Throwable)ex);
        }
    }

    private AbstractUMLEntityModel createModel(IType type) {
        try {
            if (type.isInterface()) {
                InterfaceModel model = new InterfaceModel();
                model.setName(type.getFullyQualifiedParameterizedName());
                AttributeModel[] fields = UMLJavaUtils.getFields(type);
                int i = 0;
                while (i < fields.length) {
                    model.addChild((AbstractUMLModel)fields[i]);
                    ++i;
                }
                OperationModel[] methods = UMLJavaUtils.getMethods(type);
                int i2 = 0;
                while (i2 < methods.length) {
                    model.addChild((AbstractUMLModel)methods[i2]);
                    ++i2;
                }
                return model;
            }
            if (type.isClass()) {
                ClassModel model = new ClassModel();
                model.setName(type.getFullyQualifiedParameterizedName());
                AttributeModel[] attrs = UMLJavaUtils.getFields(type);
                int i = 0;
                while (i < attrs.length) {
                    model.addChild((AbstractUMLModel)attrs[i]);
                    ++i;
                }
                OperationModel[] methods = UMLJavaUtils.getMethods(type);
                int i3 = 0;
                while (i3 < methods.length) {
                    model.addChild((AbstractUMLModel)methods[i3]);
                    ++i3;
                }
                return model;
            }
        }
        catch (Exception ex) {
            UMLPlugin.logException((Throwable)ex);
        }
        return null;
    }

    public void undo() {
        for (AbstractUMLEntityModel model : this.models) {
            for (AbstractUMLConnectionModel conn : model.getModelSourceConnections()) {
                conn.detachSource();
                conn.detachTarget();
            }
            for (AbstractUMLConnectionModel conn : model.getModelTargetConnections()) {
                conn.detachSource();
                conn.detachTarget();
            }
            this.root.removeChild((AbstractUMLModel)model);
        }
    }
}

