/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.GeneralizationModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.RealizationModel;
import net.java.amateras.uml.java.JavaExportWizardPage;
import net.java.amateras.uml.java.UMLJavaPlugin;
import net.java.amateras.uml.java.UMLJavaUtils;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class JavaExportWizard
extends Wizard {
    private JavaExportWizardPage folderPage;
    private IJavaProject project;
    private Map<String, AbstractUMLEntityModel> target = new HashMap<String, AbstractUMLEntityModel>();

    public JavaExportWizard(IJavaProject project, RootModel root) {
        this.project = project;
        this.setWindowTitle(UMLJavaPlugin.getDefault().getResourceString("generate.dialog.title"));
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (child instanceof ClassModel) {
                this.target.put(((ClassModel)child).getName(), (AbstractUMLEntityModel)child);
            }
            if (child instanceof InterfaceModel) {
                this.target.put(((InterfaceModel)child).getName(), (AbstractUMLEntityModel)child);
            }
            ++i;
        }
    }

    public void addPages() {
        Iterator<String> ite = this.target.keySet().iterator();
        ArrayList<String> classNames = new ArrayList<String>();
        while (ite.hasNext()) {
            classNames.add(ite.next());
        }
        this.folderPage = new JavaExportWizardPage(this.project, classNames.toArray(new String[classNames.size()]));
        this.addPage((IWizardPage)this.folderPage);
    }

    public boolean performFinish() {
        String outputDir = this.folderPage.getOutputFolder();
        if (outputDir.startsWith("/")) {
            outputDir = outputDir.substring(1);
        }
        if (outputDir.endsWith("/")) {
            outputDir = outputDir.substring(0, outputDir.length() - 1);
        }
        String[] selection = this.folderPage.getGenerateClasses();
        int i = 0;
        while (i < selection.length) {
            AbstractUMLEntityModel obj = this.target.get(selection[i]);
            String fileName = this.getModelName(obj).replace('.', '/');
            if (!outputDir.equals("")) {
                fileName = String.valueOf(outputDir) + "/" + fileName;
            }
            fileName = fileName.replaceAll("<.+?>", "");
            String[] folders = fileName.split("/");
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < folders.length - 1) {
                sb.append("/").append(folders[j]);
                IFolder folder = this.project.getProject().getFolder((IPath)new Path(sb.toString()));
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ++j;
            }
            IFile file = this.project.getProject().getFile((IPath)new Path(String.valueOf(fileName) + ".java"));
            String source = "";
            if (obj instanceof ClassModel) {
                source = this.createClassSource((ClassModel)obj);
            } else if (obj instanceof InterfaceModel) {
                source = this.createInterfaceSource((InterfaceModel)obj);
            }
            try {
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(source.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.create((InputStream)new ByteArrayInputStream(source.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            ++i;
        }
        return true;
    }

    private String createClassSource(ClassModel model) {
        Object child;
        String[] names = this.splitClassName(model.getName());
        StringBuffer sb = new StringBuffer();
        if (!names[0].equals("")) {
            sb.append("package ").append(names[0]).append(";\n\n");
        }
        sb.append("public ");
        if (model.isAbstract()) {
            sb.append("abstract ");
        }
        sb.append("class ").append(names[1]);
        sb.append(this.createParentRelation((AbstractUMLEntityModel)model));
        sb.append(" {\n");
        List children = model.getChildren();
        int i = 0;
        while (i < children.size()) {
            child = children.get(i);
            if (child instanceof AttributeModel) {
                sb.append(this.createAttribute((AttributeModel)child)).append("\n");
            }
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < children.size()) {
            child = children.get(i);
            if (child instanceof OperationModel) {
                OperationModel ope = (OperationModel)child;
                sb.append(this.createMethodSignature(ope));
                if (ope.isAbstract()) {
                    sb.append(";\n\n");
                } else {
                    sb.append("{");
                    sb.append("\n");
                    if (!ope.getType().equals("void") && ope.getType().length() != 0 && !ope.isConstructor()) {
                        sb.append("        ");
                        sb.append("return ");
                        sb.append(this.getDefaultValue(ope.getType()));
                        sb.append(";\n");
                    }
                    sb.append("    ");
                    sb.append("}\n\n");
                }
            }
            ++i;
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String createInterfaceSource(InterfaceModel model) {
        Object child;
        String[] names = this.splitClassName(model.getName());
        StringBuffer sb = new StringBuffer();
        if (!names[0].equals("")) {
            sb.append("package ").append(names[0]).append(";\n\n");
        }
        sb.append("public interface ").append(names[1]);
        sb.append(this.createParentRelation((AbstractUMLEntityModel)model));
        sb.append(" {\n");
        List children = model.getChildren();
        int i = 0;
        while (i < children.size()) {
            child = children.get(i);
            if (child instanceof AttributeModel) {
                sb.append(this.createAttribute((AttributeModel)child)).append("\n");
            }
            ++i;
        }
        sb.append("\n");
        i = 0;
        while (i < children.size()) {
            child = children.get(i);
            if (child instanceof OperationModel) {
                sb.append(this.createMethodSignature((OperationModel)child));
                sb.append(";\n\n");
            }
            ++i;
        }
        sb.append("}\n");
        return sb.toString();
    }

    private String createAttribute(AttributeModel attr) {
        StringBuffer sb = new StringBuffer();
        sb.append("    ");
        String visibility = attr.getVisibility().toString();
        if (!visibility.equals("package")) {
            sb.append(attr.getVisibility().toString());
            sb.append(" ");
        }
        if (attr.isStatic()) {
            sb.append("static ");
        }
        sb.append(attr.getType());
        sb.append(" ");
        sb.append(attr.getName());
        if (attr.getParent() instanceof InterfaceModel) {
            if (UMLJavaUtils.isPrimitive(attr.getType())) {
                if (attr.getType().equals("boolean")) {
                    sb.append(" = false");
                } else {
                    sb.append(" = 0");
                }
            } else {
                sb.append(" = null");
            }
        }
        sb.append(";");
        return sb.toString();
    }

    private String createMethodSignature(OperationModel ope) {
        StringBuffer sb = new StringBuffer();
        sb.append("    ");
        String visibility = ope.getVisibility().toString();
        if (!visibility.equals("package")) {
            sb.append(ope.getVisibility().toString());
            sb.append(" ");
        }
        if (ope.isStatic()) {
            sb.append("static ");
        }
        if (ope.isAbstract()) {
            sb.append("abstract ");
        }
        if (ope.getType().length() != 0 && !ope.isConstructor()) {
            sb.append(ope.getType());
            sb.append(" ");
        }
        sb.append(ope.getName());
        sb.append("(");
        List params = ope.getParams();
        int i = 0;
        while (i < params.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            Argument arg = (Argument)params.get(i);
            sb.append(arg.getType());
            sb.append(" ");
            sb.append(arg.getName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private String createParentRelation(AbstractUMLEntityModel model) {
        StringBuffer sb = new StringBuffer();
        List conns = model.getModelSourceConnections();
        int extendsCount = 0;
        for (AbstractUMLConnectionModel conn : conns) {
            if (!(conn instanceof GeneralizationModel)) continue;
            if (extendsCount == 0) {
                sb.append(" extends ");
            } else {
                sb.append(", ");
            }
            AbstractUMLEntityModel target = ((GeneralizationModel)conn).getTarget();
            sb.append(this.getModelName(target));
            ++extendsCount;
        }
        int implementsCount = 0;
        for (AbstractUMLConnectionModel conn : conns) {
            if (!(conn instanceof RealizationModel)) continue;
            if (implementsCount == 0) {
                sb.append(" implements ");
            } else {
                sb.append(", ");
            }
            AbstractUMLEntityModel target = ((RealizationModel)conn).getTarget();
            sb.append(this.getModelName(target));
            ++implementsCount;
        }
        return sb.toString();
    }

    private String[] splitClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return new String[]{"", className};
        }
        return new String[]{className.substring(0, index), className.substring(index + 1)};
    }

    private String getDefaultValue(String type) {
        if (type.equals("int") || type.equals("long") || type.equals("double") || type.equals("short") || type.equals("char")) {
            return "0";
        }
        if (type.equals("boolean")) {
            return "false";
        }
        return "null";
    }

    private String getModelName(AbstractUMLEntityModel model) {
        if (model instanceof ClassModel) {
            return ((ClassModel)model).getName();
        }
        if (model instanceof InterfaceModel) {
            return ((InterfaceModel)model).getName();
        }
        return null;
    }
}

