/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.java.amateras.uml.java.UMLJavaPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JavaExportWizardPage
extends WizardPage {
    private IJavaProject project;
    private String[] classNames;
    private Table list;
    private Text srcdir;
    private static Set<String> unchecked = new HashSet<String>();

    public JavaExportWizardPage(IJavaProject project, String[] classNames) {
        super("Output Folder");
        this.setTitle(UMLJavaPlugin.getDefault().getResourceString("generate.dialog.title"));
        this.project = project;
        this.classNames = classNames;
    }

    public String getOutputFolder() {
        return this.srcdir.getText();
    }

    public String[] getGenerateClasses() {
        ArrayList<String> selection = new ArrayList<String>();
        TableItem[] items = this.list.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                selection.add(items[i].getText());
            } else {
                unchecked.add(items[i].getText());
            }
            ++i;
        }
        return selection.toArray(new String[selection.size()]);
    }

    public void createControl(Composite parent) {
        UMLJavaPlugin plugin = UMLJavaPlugin.getDefault();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(plugin.getResourceString("generate.dialog.srcdir"));
        this.srcdir = new Text(composite, 2048);
        this.srcdir.setLayoutData((Object)new GridData(768));
        Button button = new Button(composite, 8);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaExportWizardPage.this.selectFolder();
            }
        });
        label = new Label(composite, 0);
        label.setText(plugin.getResourceString("generate.dialog.types"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.list = new Table(composite, 2592);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.list.setLayoutData((Object)gd);
        int i = 0;
        while (i < this.classNames.length) {
            TableItem item = new TableItem(this.list, 0);
            item.setText(this.classNames[i]);
            if (!unchecked.contains(this.classNames[i])) {
                item.setChecked(true);
            }
            ++i;
        }
        try {
            IPackageFragmentRoot[] roots = this.project.getPackageFragmentRoots();
            int i2 = 0;
            while (i2 < roots.length) {
                IResource classpath = roots[i2].getResource();
                if (classpath != null && (classpath instanceof IFolder || classpath instanceof IProject)) {
                    this.srcdir.setText(classpath.getProjectRelativePath().toString());
                    break;
                }
                ++i2;
            }
        }
        catch (Exception exception) {}
        this.setControl((Control)composite);
    }

    private void selectFolder() {
        try {
            IProject currProject = this.project.getProject();
            IResource init = null;
            if (!this.srcdir.getText().equals("")) {
                init = currProject.findMember(this.srcdir.getText());
            }
            Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
            TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] allProjects = wsroot.getProjects();
            ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
            int i = 0;
            while (i < allProjects.length) {
                if (!allProjects[i].equals((Object)currProject)) {
                    rejectedElements.add(allProjects[i]);
                }
                ++i;
            }
            TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
            FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle("Select output folder");
            dialog.setMessage("Select output folder:");
            dialog.setInput((Object)wsroot);
            dialog.setValidator((ISelectionStatusValidator)validator);
            dialog.addFilter((ViewerFilter)filter);
            dialog.setInitialSelection((Object)init);
            if (dialog.open() == 0) {
                this.srcdir.setText(this.getFolderName(dialog.getFirstResult()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private String getFolderName(Object result) throws CoreException {
        if (result instanceof IFolder) {
            IFolder folder = (IFolder)result;
            return folder.getProjectRelativePath().toString();
        }
        return "";
    }
}

