/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java;

import java.util.List;
import net.java.amateras.uml.classdiagram.ClassDiagramEditor;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.java.UMLJavaUtils;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class OpenSourceAction
implements IEditorActionDelegate {
    private ClassDiagramEditor editor;
    private IStructuredSelection selection;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (ClassDiagramEditor)targetEditor;
        action.setEnabled(false);
    }

    public void run(IAction action) {
        EditPart parent;
        if (this.selection == null || this.selection.getFirstElement() == null) {
            return;
        }
        Object obj = this.selection.getFirstElement();
        if (obj == null && !(obj instanceof EditPart)) {
            return;
        }
        String className = null;
        String methodName = null;
        String fieldName = null;
        int methodIndex = 0;
        Object model = ((EditPart)obj).getModel();
        if (model instanceof ClassModel) {
            className = ((ClassModel)model).getName();
        } else if (model instanceof InterfaceModel) {
            className = ((InterfaceModel)model).getName();
        } else if (model instanceof OperationModel) {
            parent = ((EditPart)obj).getParent();
            className = UMLJavaUtils.getClassName(parent.getModel());
            methodName = ((OperationModel)model).getName();
            methodIndex = this.getMethodIndex(parent, (OperationModel)model);
        } else if (model instanceof AttributeModel) {
            parent = ((EditPart)obj).getParent();
            className = UMLJavaUtils.getClassName(parent.getModel());
            fieldName = ((AttributeModel)model).getName();
        }
        if (className != null) {
            className = UMLJavaUtils.stripGenerics(className);
            IFileEditorInput input = (IFileEditorInput)this.editor.getEditorInput();
            IJavaProject project = JavaCore.create((IProject)input.getFile().getProject());
            try {
                IType type = project.findType(className);
                if (type != null && type.exists()) {
                    IField field;
                    IMethod method;
                    if (methodName != null && this.openInEditor((IJavaElement)(method = this.getMethod(type, methodName, methodIndex)))) {
                        return;
                    }
                    if (fieldName != null && this.openInEditor((IJavaElement)(field = type.getField(fieldName)))) {
                        return;
                    }
                    JavaUI.openInEditor((IJavaElement)type);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean openInEditor(IJavaElement element) {
        try {
            if (element != null && element.exists()) {
                JavaUI.openInEditor((IJavaElement)element, (boolean)true, (boolean)true);
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private int getMethodIndex(EditPart editPart, OperationModel model) {
        Object parentModel = editPart.getModel();
        List children = ((AbstractUMLEntityModel)parentModel).getChildren();
        int index = 0;
        for (AbstractUMLModel obj : children) {
            if (!(obj instanceof OperationModel) || !((OperationModel)obj).getName().equals(model.getName())) continue;
            if (obj == model) break;
            ++index;
        }
        return index;
    }

    private IMethod getMethod(IType type, String methodName, int index) {
        try {
            IMethod[] methods = type.getMethods();
            int count = 0;
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(methodName)) {
                    if (count == index) {
                        return methods[i];
                    }
                    ++count;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object model;
        Object obj;
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
        if (this.selection != null && this.selection.getFirstElement() != null && (obj = this.selection.getFirstElement()) instanceof EditPart && ((model = ((EditPart)obj).getModel()) instanceof ClassModel || model instanceof InterfaceModel || model instanceof AttributeModel || model instanceof OperationModel)) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }
}

