/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.amateras.uml.classdiagram.ClassDiagramEditor;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.java.ImportClassModelCommand;
import net.java.amateras.uml.java.UMLJavaUtils;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class SyncAction
implements IEditorActionDelegate {
    private ClassDiagramEditor editor;
    private List<AbstractUMLEntityModel> target = new ArrayList<AbstractUMLEntityModel>();

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (ClassDiagramEditor)targetEditor;
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.target.isEmpty()) {
            return;
        }
        for (AbstractUMLEntityModel model : new ArrayList<AbstractUMLEntityModel>(this.target)) {
            String className = null;
            if (model instanceof ClassModel) {
                className = ((ClassModel)model).getName();
            } else if (model instanceof InterfaceModel) {
                className = ((InterfaceModel)model).getName();
            }
            className = UMLJavaUtils.stripGenerics(className);
            IEditorInput input = this.editor.getEditorInput();
            if (!(input instanceof IFileEditorInput)) continue;
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
                IType type = javaProject.findType(className);
                if (type == null || !type.exists()) continue;
                RootModel root = (RootModel)this.editor.getAdapter(RootModel.class);
                CommandStack stack = (CommandStack)this.editor.getAdapter(CommandStack.class);
                CommandChain commandChain = new CommandChain();
                AbstractUMLEntityEditPart.DeleteCommand deleteCommand = new AbstractUMLEntityEditPart.DeleteCommand();
                deleteCommand.setRootModel((Object)root);
                deleteCommand.setTargetModel((Object)model);
                commandChain.add((Command)deleteCommand);
                ImportClassModelCommand importCommand = new ImportClassModelCommand(root, type);
                Rectangle rect = model.getConstraint();
                importCommand.setLocation(new Point(rect.x, rect.y));
                commandChain.add(importCommand);
                stack.execute((Command)commandChain);
            }
            catch (JavaModelException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.target.clear();
        if (selection != null && selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object model;
                Object obj = objectArray[n2];
                if (obj instanceof EditPart && ((model = ((EditPart)obj).getModel()) instanceof ClassModel || model instanceof InterfaceModel)) {
                    this.target.add((AbstractUMLEntityModel)model);
                }
                ++n2;
            }
        }
        if (this.target.isEmpty()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }

    private static class CommandChain
    extends Command {
        private List<Command> commandList = new ArrayList<Command>();

        private CommandChain() {
        }

        public void add(Command command) {
            this.commandList.add(command);
        }

        public void execute() {
            for (Command command : this.commandList) {
                command.execute();
            }
        }

        public void undo() {
            ArrayList<Command> revervseList = new ArrayList<Command>(this.commandList);
            Collections.reverse(revervseList);
            for (Command command : revervseList) {
                command.undo();
            }
        }
    }
}

