/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.model.AggregationModel;
import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.GeneralizationModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.RealizationModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class UMLJavaUtils {
    public static String getClassName(Object model) {
        if (model instanceof ClassModel) {
            return ((ClassModel)model).getName();
        }
        if (model instanceof InterfaceModel) {
            return ((InterfaceModel)model).getName();
        }
        return null;
    }

    public static boolean isPrimitive(String type) {
        return type.equals("int") || type.equals("long") || type.equals("double") || type.equals("float") || type.equals("char") || type.equals("boolean") || type.equals("byte");
    }

    public static String getFullQName(IType parent, String type) {
        IType javaType;
        if ((type = UMLJavaUtils.stripGenerics(type)).indexOf(46) >= 0) {
            return type;
        }
        if (UMLJavaUtils.isPrimitive(type)) {
            return type;
        }
        IJavaProject project = parent.getJavaProject();
        try {
            javaType = project.findType("java.lang." + type);
            if (javaType != null && javaType.exists()) {
                return javaType.getFullyQualifiedName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            javaType = project.findType(String.valueOf(parent.getPackageFragment().getElementName()) + "." + type);
            if (javaType != null && javaType.exists()) {
                return javaType.getFullyQualifiedName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            IImportDeclaration[] imports = parent.getCompilationUnit().getImports();
            int i = 0;
            while (i < imports.length) {
                String importName = imports[i].getElementName();
                if (importName.endsWith("." + type)) {
                    return importName;
                }
                if (importName.endsWith(".*")) {
                    try {
                        IType javaType2 = project.findType(importName.replaceFirst("\\*$", type));
                        if (javaType2 != null && javaType2.exists()) {
                            return javaType2.getFullyQualifiedName();
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return type;
    }

    public static AttributeModel[] getFields(IType type) {
        try {
            IField[] fields = type.getFields();
            AttributeModel[] result = new AttributeModel[fields.length];
            int i = 0;
            while (i < fields.length) {
                AttributeModel attr = new AttributeModel();
                attr.setName(fields[i].getElementName());
                attr.setType(Signature.toString((String)fields[i].getTypeSignature()));
                attr.setStatic(Flags.isStatic((int)fields[i].getFlags()));
                if (type.isInterface()) {
                    attr.setVisibility(Visibility.PUBLIC);
                } else if (Flags.isPublic((int)fields[i].getFlags())) {
                    attr.setVisibility(Visibility.PUBLIC);
                } else if (Flags.isPrivate((int)fields[i].getFlags())) {
                    attr.setVisibility(Visibility.PRIVATE);
                } else if (Flags.isProtected((int)fields[i].getFlags())) {
                    attr.setVisibility(Visibility.PROTECTED);
                } else {
                    attr.setVisibility(Visibility.PACKAGE);
                }
                result[i] = attr;
                ++i;
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new AttributeModel[0];
        }
    }

    public static OperationModel[] getMethods(IType type) {
        try {
            IMethod[] methods = type.getMethods();
            OperationModel[] result = new OperationModel[methods.length];
            int i = 0;
            while (i < methods.length) {
                OperationModel ope = new OperationModel();
                ope.setName(methods[i].getElementName());
                ope.setType(Signature.toString((String)methods[i].getReturnType()));
                if (Flags.isPublic((int)methods[i].getFlags())) {
                    ope.setVisibility(Visibility.PUBLIC);
                } else if (Flags.isPrivate((int)methods[i].getFlags())) {
                    ope.setVisibility(Visibility.PRIVATE);
                } else if (Flags.isProtected((int)methods[i].getFlags())) {
                    ope.setVisibility(Visibility.PROTECTED);
                } else {
                    ope.setVisibility(Visibility.PACKAGE);
                }
                ope.setAbstract(Flags.isAbstract((int)methods[i].getFlags()));
                ope.setStatic(Flags.isStatic((int)methods[i].getFlags()));
                ArrayList<Argument> params = new ArrayList<Argument>();
                String[] names = methods[i].getParameterNames();
                String[] types = methods[i].getParameterTypes();
                int j = 0;
                while (j < names.length) {
                    Argument arg = new Argument();
                    arg.setName(names[j]);
                    arg.setType(Signature.toString((String)types[j]));
                    params.add(arg);
                    ++j;
                }
                ope.setParams(params);
                result[i] = ope;
                ++i;
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new OperationModel[0];
        }
    }

    public static void appendSuperClassConnection(RootModel root, IType type, AbstractUMLEntityModel model) throws JavaModelException {
        if (type.getSuperclassName() == null) {
            return;
        }
        String superClass = UMLJavaUtils.getFullQName(type, type.getSuperclassName());
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Object obj = children.get(i);
            String className = UMLJavaUtils.stripGenerics(UMLJavaUtils.getClassName(obj));
            if (className != null && className.equals(superClass)) {
                GeneralizationModel conn = new GeneralizationModel();
                conn.setSource(model);
                conn.setTarget((AbstractUMLEntityModel)obj);
                conn.attachSource();
                conn.attachTarget();
                break;
            }
            ++i;
        }
    }

    public static void appendSubConnection(RootModel root, IJavaProject project, AbstractUMLEntityModel model) {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            AbstractUMLEntityModel child = (AbstractUMLEntityModel)children.get(i);
            if (child != model) {
                IType type;
                String name;
                if (child instanceof InterfaceModel) {
                    name = ((InterfaceModel)child).getName();
                    try {
                        type = project.findType(name);
                        if (type != null) {
                            UMLJavaUtils.appendInterfacesConnection(root, type, child);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (child instanceof ClassModel) {
                    name = ((ClassModel)child).getName();
                    try {
                        type = project.findType(name);
                        if (type != null) {
                            UMLJavaUtils.appendSuperClassConnection(root, type, child);
                            UMLJavaUtils.appendInterfacesConnection(root, type, child);
                            UMLJavaUtils.appendAggregationConnection(root, type, (ClassModel)child);
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            ++i;
        }
    }

    public static void appendInterfacesConnection(RootModel root, IType type, AbstractUMLEntityModel model) throws JavaModelException {
        String[] interfaces = type.getSuperInterfaceNames();
        int i = 0;
        while (i < interfaces.length) {
            String interfaceName = UMLJavaUtils.getFullQName(type, interfaces[i]);
            List children = root.getChildren();
            int j = 0;
            while (j < children.size()) {
                String className;
                Object obj = children.get(j);
                if (obj instanceof InterfaceModel && (className = UMLJavaUtils.stripGenerics(((InterfaceModel)obj).getName())) != null && className.equals(interfaceName)) {
                    RealizationModel conn = null;
                    if (model instanceof ClassModel) {
                        conn = new RealizationModel();
                    } else if (model instanceof InterfaceModel) {
                        conn = new GeneralizationModel();
                    }
                    conn.setSource(model);
                    conn.setTarget((AbstractUMLEntityModel)obj);
                    conn.attachSource();
                    conn.attachTarget();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void appendAggregationConnection(RootModel root, IType type, ClassModel model) throws JavaModelException {
        List children = model.getChildren();
        block0: for (AbstractUMLModel obj : children) {
            if (!(obj instanceof AttributeModel)) continue;
            AttributeModel attr = (AttributeModel)obj;
            String attrType = attr.getType();
            if (attrType.startsWith("List") || attrType.startsWith("java.util.List")) {
                int fromIndex = attrType.indexOf(60);
                int endIndex = attrType.indexOf(62);
                if (fromIndex >= 0 && endIndex >= 0) {
                    attrType = attrType.substring(fromIndex + 1, endIndex);
                }
            }
            attrType = attrType.replaceAll("<.*>", "");
            attrType = attrType.replaceAll("\\[\\]", "");
            attrType = UMLJavaUtils.getFullQName(type, attrType);
            List entities = root.getChildren();
            for (AbstractUMLModel entity : entities) {
                AggregationModel conn;
                if (entity instanceof ClassModel) {
                    if (!UMLJavaUtils.stripGenerics(((ClassModel)entity).getName()).equals(attrType)) continue;
                    conn = new AggregationModel();
                    conn.setSource((AbstractUMLEntityModel)((ClassModel)entity));
                    conn.setTarget((AbstractUMLEntityModel)model);
                    conn.attachSource();
                    conn.attachTarget();
                    continue block0;
                }
                if (!(entity instanceof InterfaceModel) || !UMLJavaUtils.stripGenerics(((InterfaceModel)entity).getName()).equals(attrType)) continue;
                conn = new AggregationModel();
                conn.setSource((AbstractUMLEntityModel)((InterfaceModel)entity));
                conn.setTarget((AbstractUMLEntityModel)model);
                conn.attachSource();
                conn.attachTarget();
                continue block0;
            }
        }
    }

    public static String stripGenerics(String className) {
        if (className != null) {
            className = className.replaceAll("<.+?>", "");
        }
        return className;
    }

    public static IType[] getTypes(IJavaElement element) {
        try {
            ArrayList<IType> list = new ArrayList<IType>();
            if (element instanceof ICompilationUnit) {
                IType[] types = ((ICompilationUnit)element).getTypes();
                int i = 0;
                while (i < types.length) {
                    list.add(types[i]);
                    UMLJavaUtils.extractTypes(list, types[i]);
                    ++i;
                }
            } else if (element instanceof IClassFile) {
                IType type = ((IClassFile)element).getType();
                list.add(type);
                UMLJavaUtils.extractTypes(list, type);
            } else if (element instanceof IType) {
                IType type = (IType)element;
                list.add(type);
                UMLJavaUtils.extractTypes(list, type);
            }
            return list.toArray(new IType[list.size()]);
        }
        catch (JavaModelException ex) {
            UMLPlugin.logException((Throwable)ex);
            return null;
        }
    }

    private static void extractTypes(List<IType> list, IType type) {
        try {
            IType[] types = type.getTypes();
            int i = 0;
            while (i < types.length) {
                if (!list.contains(types[i])) {
                    list.add(types[i]);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

