/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.java.views;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.SequenceModelBuilder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.part.ViewPart;

public class SampleView
extends ViewPart {
    private Action action1;
    private Text text;

    public void createPartControl(Composite parent) {
        this.text = new Text(parent, 514);
        this.text.setToolTipText("Paste Stack Trace here and execute action!");
        this.makeActions();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                ContainerSelectionDialog dialog;
                String content = SampleView.this.convertSequenceDiagram();
                if (content != null && (dialog = new ContainerSelectionDialog(SampleView.this.text.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Choose destination of new sequence")).open() == 0) {
                    Object[] objects = dialog.getResult();
                    IPath container = (IPath)objects[0];
                    IPath path = container.append((IPath)new Path("stacktrace.sqd"));
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                    try {
                        if (file.exists()) {
                            file.setContents((InputStream)new ByteArrayInputStream(content.getBytes()), true, true, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.action1.setText("Generate");
        this.action1.setToolTipText("Generate Sequence Diagram from Stack Trace.");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private String convertSequenceDiagram() {
        String string = this.text.getText();
        String[] strings = string.split("\n");
        ArrayList<String> stacks = new ArrayList<String>();
        int i = strings.length - 1;
        while (i > 0) {
            if (strings[i].trim().startsWith("at")) {
                stacks.add(strings[i].trim());
            }
            --i;
        }
        SequenceModelBuilder builder = new SequenceModelBuilder();
        builder.init((InstanceModel)builder.createActor("User"));
        HashMap<String, InstanceModel> instances = new HashMap<String, InstanceModel>();
        String prev = null;
        for (String element : stacks) {
            InstanceModel model;
            String name = this.getClassName(element);
            String method = this.getMethodName(element);
            if (name == null || method == null) continue;
            if (method.equals("<<init>>")) {
                model = builder.createInstance(name);
                builder.createCreationMessage("create", model);
                instances.put(name, model);
            } else if (name.equals(prev)) {
                builder.createSelfCallMessage(method);
            } else if (instances.get(name) == null) {
                model = builder.createInstance(name);
                builder.createMessage(method, model);
                instances.put(name, model);
            } else {
                model = (InstanceModel)instances.get(name);
                builder.createMessage(method, model);
            }
            prev = name;
        }
        return builder.toXML();
    }

    private String getMethodName(String line) {
        String fqn = this.getFQN(line);
        if (fqn == null) {
            return null;
        }
        return fqn.substring(fqn.lastIndexOf(46) + 1);
    }

    private String getClassName(String line) {
        String fqn = this.getFQN(line);
        if (fqn == null) {
            return null;
        }
        String newFqn = fqn.substring(0, fqn.lastIndexOf(46));
        if (newFqn.lastIndexOf(46) > 0) {
            return newFqn.substring(newFqn.lastIndexOf(46) + 1);
        }
        return newFqn;
    }

    private String getFQN(String line) {
        if (line.indexOf(40) > 0 && line.length() > 4) {
            return line.substring(3, line.lastIndexOf(40));
        }
        return null;
    }

    public void setFocus() {
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return new String[]{"One", "Two", "Three"};
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

