/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import net.java.amateras.uml.DiagramSerializer;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.action.CopyAsImageAction;
import net.java.amateras.uml.action.OpenOutlineViewAction;
import net.java.amateras.uml.action.OpenPropertyViewAction;
import net.java.amateras.uml.action.SaveAsImageAction;
import net.java.amateras.uml.dnd.UMLDropTargetListenerFactory;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class DiagramEditor
extends GraphicalEditorWithPalette
implements IPropertyChangeListener,
IResourceChangeListener {
    private boolean savePreviouslyNeeded = false;
    private AbstractUMLEditorAction openOutlineAction = null;
    private AbstractUMLEditorAction openPropertyAction = null;
    private AbstractUMLEditorAction saveAsImageAction = null;
    private AbstractUMLEditorAction copyAsImageAction = null;
    private boolean needViewerRefreshFlag = true;
    private KeyHandler sharedKeyHandler;

    public DiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getActionRegistry().registerAction((IAction)new UndoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new RedoRetargetAction());
        this.getActionRegistry().registerAction((IAction)new DeleteRetargetAction());
        UMLPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        RootModel root = null;
        if (file.exists()) {
            try {
                root = DiagramSerializer.deserialize(file.getContents());
                this.validateModel(root);
            }
            catch (Exception ex) {
                UMLPlugin.logException(ex);
            }
        }
        if (root == null) {
            root = this.createInitializeModel();
        }
        viewer.setContents((Object)root);
        this.addDndSupport(viewer, this.getDiagramType());
        this.applyPreferences();
    }

    private void refreshGraphicalViewer() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                IFile file = ((IFileEditorInput)input).getFile();
                GraphicalViewer viewer = this.getGraphicalViewer();
                RootModel newRoot = null;
                try {
                    newRoot = DiagramSerializer.deserialize(file.getContents());
                }
                catch (Exception ex) {
                    UMLPlugin.logException(ex);
                    return;
                }
                RootModel root = (RootModel)viewer.getContents().getModel();
                root.copyFrom(newRoot);
            }
            catch (Exception ex) {
                UMLPlugin.logException(ex);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)DiagramEditor.this, false);
                    } else {
                        if (!DiagramEditor.this.getPartName().equals(file.getName())) {
                            DiagramEditor.this.setPartName(file.getName());
                        }
                        if (DiagramEditor.this.needViewerRefreshFlag) {
                            DiagramEditor.this.refreshGraphicalViewer();
                        } else {
                            DiagramEditor.this.needViewerRefreshFlag = true;
                        }
                    }
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.applyPreferences();
    }

    protected void applyPreferences() {
        IPreferenceStore store = UMLPlugin.getDefault().getPreferenceStore();
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)new Boolean(store.getBoolean("pref.showgrid")));
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)new Boolean(store.getBoolean("pref.showgrid")));
        int gridSize = store.getInt("pref.gridsize");
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridSize, gridSize));
        this.getGraphicalViewer().setProperty("SnapToGeometry.isEnabled", (Object)new Boolean(store.getBoolean("pref.snapgeometry")));
    }

    private void validateModel(AbstractUMLEntityModel parent) {
        List<AbstractUMLModel> children = parent.getChildren();
        for (AbstractUMLModel element : children) {
            if (element.getParent() == null) {
                element.setParent(parent);
            }
            if (!(element instanceof AbstractUMLEntityModel)) continue;
            this.validateModel((AbstractUMLEntityModel)element);
        }
    }

    protected abstract RootModel createInitializeModel();

    protected abstract String getDiagramType();

    public static final RootModel getActiveDiagramModel() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorPart editor = window.getActivePage().getActiveEditor();
            return (RootModel)editor.getAdapter(RootModel.class);
        }
        return null;
    }

    private void addDndSupport(GraphicalViewer viewer, String type) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("net.java.amateras.umleditor", "dnd");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                try {
                    UMLDropTargetListenerFactory factory;
                    Object object = element.createExecutableExtension("class");
                    if (object instanceof UMLDropTargetListenerFactory && (factory = (UMLDropTargetListenerFactory)object).accept(type)) {
                        TransferDropTargetListener targetListener = factory.getDropTargetListener((EditPartViewer)viewer);
                        viewer.addDropTargetListener(targetListener);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory(this.createEditPartFactory());
        ScalableRootEditPart rootEditPart = new ScalableRootEditPart();
        viewer.setRootEditPart((RootEditPart)rootEditPart);
        ZoomManager manager = rootEditPart.getZoomManager();
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0, 20.0};
        manager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        manager.setZoomLevelContributions(zoomContributions);
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(manager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(manager));
        this.getGraphicalViewer().setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(this.getGraphicalViewer()));
        String menuId = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".EditorContext";
        MenuManager menuMgr = new MenuManager(menuId, menuId);
        this.openPropertyAction = new OpenPropertyViewAction(viewer);
        this.openOutlineAction = new OpenOutlineViewAction(viewer);
        this.saveAsImageAction = new SaveAsImageAction(viewer);
        this.copyAsImageAction = new CopyAsImageAction(viewer);
        this.createDiagramAction(viewer);
        this.getSite().registerContextMenu(menuId, menuMgr, (ISelectionProvider)viewer);
        PrintAction printAction = new PrintAction((IWorkbenchPart)this);
        printAction.setImageDescriptor(UMLPlugin.getImageDescriptor("icons/print.gif"));
        this.getActionRegistry().registerAction((IAction)printAction);
        final DeleteAction deleteAction = new DeleteAction((IWorkbenchPart)this);
        deleteAction.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)deleteAction);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteAction.update();
            }
        });
        menuMgr.add((IContributionItem)new Separator("edit"));
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()));
        menuMgr.add(this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
        menuMgr.add((IContributionItem)new Separator("zoom"));
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        menuMgr.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        this.fillDiagramPopupMenu(menuMgr);
        menuMgr.add((IContributionItem)new Separator("print"));
        menuMgr.add((IAction)this.saveAsImageAction);
        menuMgr.add((IAction)this.copyAsImageAction);
        menuMgr.add((IAction)printAction);
        menuMgr.add((IContributionItem)new Separator("views"));
        menuMgr.add((IAction)this.openPropertyAction);
        menuMgr.add((IAction)this.openOutlineAction);
        menuMgr.add((IContributionItem)new Separator("generate"));
        menuMgr.add((IContributionItem)new Separator("additions"));
        viewer.setContextMenu(menuMgr);
        viewer.setKeyHandler(new GraphicalViewerKeyHandler(viewer).setParent(this.getCommonKeyHandler()));
    }

    protected abstract void createDiagramAction(GraphicalViewer var1);

    protected abstract void fillDiagramPopupMenu(MenuManager var1);

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                this.needViewerRefreshFlag = false;
                IFile file = ((IFileEditorInput)input).getFile();
                file.setContents(DiagramSerializer.serialize((RootModel)this.getGraphicalViewer().getContents().getModel()), true, true, monitor);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void dispose() {
        UMLPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    protected PaletteEntry createEntityEntry(String itemName, Class<?> clazz, String icon) {
        CreationToolEntry entry = new CreationToolEntry(itemName, itemName, (CreationFactory)new SimpleFactory(clazz), UMLPlugin.getImageDescriptor(icon), UMLPlugin.getImageDescriptor(icon));
        return entry;
    }

    protected PaletteEntry createConnectionEntry(String itemName, Class<?> clazz, String icon) {
        ConnectionCreationToolEntry entry = new ConnectionCreationToolEntry(itemName, itemName, (CreationFactory)new SimpleFactory(clazz), UMLPlugin.getImageDescriptor(icon), UMLPlugin.getImageDescriptor(icon));
        return entry;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (selection instanceof IStructuredSelection) {
            this.openPropertyAction.update((IStructuredSelection)selection);
            this.openOutlineAction.update((IStructuredSelection)selection);
            this.saveAsImageAction.update((IStructuredSelection)selection);
            this.updateDiagramAction(selection);
        }
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected abstract void updateDiagramAction(ISelection var1);

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == IContentOutlinePage.class) {
            return new UMLContentOutlinePage();
        }
        if (type == RootModel.class) {
            return this.getGraphicalViewer().getContents().getModel();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        return super.getAdapter(type);
    }

    private class UMLContentOutlinePage
    implements IContentOutlinePage {
        private Canvas canvas;
        private ScrollableThumbnail thumbnail;
        private DisposeListener disposeListener;

        private UMLContentOutlinePage() {
        }

        public void createControl(Composite parent) {
            this.canvas = new Canvas(parent, 2048);
            LightweightSystem lws = new LightweightSystem(this.canvas);
            ScalableRootEditPart rootEditPart = (ScalableRootEditPart)DiagramEditor.this.getGraphicalViewer().getRootEditPart();
            this.thumbnail = new ScrollableThumbnail((Viewport)rootEditPart.getFigure());
            this.thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (UMLContentOutlinePage.this.thumbnail != null) {
                        UMLContentOutlinePage.this.thumbnail.deactivate();
                        UMLContentOutlinePage.this.thumbnail = null;
                    }
                }
            };
            DiagramEditor.this.getGraphicalViewer().getControl().addDisposeListener(this.disposeListener);
        }

        public Control getControl() {
            return this.canvas;
        }

        public void dispose() {
            if (DiagramEditor.this.getGraphicalViewer().getControl() != null && !DiagramEditor.this.getGraphicalViewer().getControl().isDisposed()) {
                DiagramEditor.this.getGraphicalViewer().getControl().removeDisposeListener(this.disposeListener);
            }
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return null;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

