/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.action;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractPasteAction;
import net.java.amateras.uml.model.ICloneableModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractCopyAction
extends SelectionAction {
    private AbstractPasteAction pasteAction;
    private List<Class<?>> allowModelTypes = new ArrayList();

    public AbstractCopyAction(IWorkbenchPart part, AbstractPasteAction pasteAction) {
        super(part);
        this.setId(ActionFactory.COPY.getId());
        this.setActionDefinitionId(ActionFactory.COPY.getId());
        this.setText(UMLPlugin.getDefault().getResourceString("menu.copy"));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.pasteAction = pasteAction;
    }

    protected void registerAllowType(Class<?> type) {
        this.allowModelTypes.add(type);
    }

    public void run() {
        List selection = this.getSelectedObjects();
        ArrayList<Object> copied = new ArrayList<Object>();
        int i = 0;
        while (i < selection.size()) {
            EditPart editPart = (EditPart)selection.get(i);
            if (this.isAllowType(editPart.getModel().getClass())) {
                ICloneableModel cloneable = (ICloneableModel)editPart.getModel();
                copied.add(cloneable.clone());
            }
            ++i;
        }
        Clipboard.getDefault().setContents(copied);
        this.pasteAction.update();
    }

    protected boolean calculateEnabled() {
        List selected = this.getSelectedObjects();
        if (selected.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < selected.size()) {
            if (!(selected.get(i) instanceof EditPart)) {
                return false;
            }
            EditPart editPart = (EditPart)selected.get(i);
            if (this.isAllowType(editPart.getModel().getClass())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAllowType(Class<?> type) {
        int j = 0;
        while (j < this.allowModelTypes.size()) {
            Class<?> allowModelType = this.allowModelTypes.get(j);
            if (allowModelType.isAssignableFrom(type)) {
                return true;
            }
            ++j;
        }
        return false;
    }
}

