/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.action;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.DiagramEditor;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.RootEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.ICloneableModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractPasteAction
extends SelectionAction {
    private List<Class<?>> allowModelTypes = new ArrayList();

    public AbstractPasteAction(IWorkbenchPart part) {
        super(part);
        this.setId(ActionFactory.PASTE.getId());
        this.setActionDefinitionId(ActionFactory.PASTE.getId());
        this.setText(UMLPlugin.getDefault().getResourceString("menu.paste"));
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    protected void registerAllowType(Class<?> type) {
        this.allowModelTypes.add(type);
    }

    public void run() {
        List model = (List)Clipboard.getDefault().getContents();
        if (model == null) {
            return;
        }
        CommandStack stack = (CommandStack)((DiagramEditor)this.getWorkbenchPart()).getAdapter(CommandStack.class);
        stack.execute((Command)new PasteCommand(model));
    }

    private Rectangle getNewRectangle(Rectangle rect) {
        Rectangle newRect = new Rectangle();
        newRect.x = rect.x + 5;
        newRect.y = rect.y + 5;
        newRect.width = rect.width;
        newRect.height = rect.height;
        return newRect;
    }

    protected boolean calculateEnabled() {
        Object obj = Clipboard.getDefault().getContents();
        if (obj == null) {
            return false;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            int i = 0;
            while (i < list.size()) {
                Object element = list.get(i);
                int j = 0;
                while (j < this.allowModelTypes.size()) {
                    Class<?> type = this.allowModelTypes.get(j);
                    if (type.isAssignableFrom(element.getClass())) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return true;
    }

    private class PasteCommand
    extends Command {
        private List<Object> target;

        public PasteCommand(List<Object> target) {
            this.target = target;
        }

        public void execute() {
            ArrayList<Object> copied = new ArrayList<Object>();
            int i = 0;
            while (i < this.target.size()) {
                ICloneableModel obj = (ICloneableModel)this.target.get(i);
                if (obj instanceof AbstractUMLEntityModel) {
                    AbstractUMLEntityModel entity = (AbstractUMLEntityModel)((Object)obj);
                    entity.setConstraint(AbstractPasteAction.this.getNewRectangle(entity.getConstraint()));
                }
                EditPart rootEditPart = this.getRootEditPart();
                ((AbstractUMLEntityModel)rootEditPart.getModel()).addChild((AbstractUMLModel)((Object)obj));
                copied.add(obj.clone());
                ++i;
            }
            Clipboard.getDefault().setContents(copied);
        }

        private EditPart getRootEditPart() {
            Object item;
            List selected = AbstractPasteAction.this.getSelectedObjects();
            EditPart rootEditPart = null;
            if (selected.size() > 0 && (item = selected.get(0)) instanceof EditPart) {
                EditPart selectedEditPart = (EditPart)item;
                while (!(selectedEditPart instanceof RootEditPart)) {
                    selectedEditPart = selectedEditPart.getParent();
                }
                rootEditPart = selectedEditPart;
            }
            return rootEditPart;
        }

        public void undo() {
            int i = 0;
            while (i < this.target.size()) {
                ICloneableModel obj = (ICloneableModel)this.target.get(i);
                obj.getParent().removeChild((AbstractUMLModel)((Object)obj));
                ++i;
            }
            Clipboard.getDefault().setContents(this.target);
        }
    }
}

