/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.action;

import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class SaveAsImageAction
extends AbstractUMLEditorAction {
    public SaveAsImageAction(GraphicalViewer viewer) {
        super(UMLPlugin.getDefault().getResourceString("menu.saveAsImage"), viewer);
        this.setImageDescriptor(UMLPlugin.getImageDescriptor("icons/save_as_image.gif"));
    }

    @Override
    public void update(IStructuredSelection sel) {
    }

    public void run() {
        ScalableRootEditPart rootEditPart = (ScalableRootEditPart)this.getViewer().getRootEditPart();
        double zoom = rootEditPart.getZoomManager().getZoom();
        try {
            try {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFileName(String.valueOf(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getTitle()) + ".jpg");
                String file = dialog.open();
                if (file != null) {
                    IFigure figure = rootEditPart.getLayer((Object)"Printable Layers");
                    Rectangle rectangle = figure.getBounds();
                    Image image = new Image((Device)Display.getDefault(), rectangle.width + 50, rectangle.height + 50);
                    GC gc = new GC((Drawable)image);
                    SWTGraphics graphics = new SWTGraphics(gc);
                    figure.paint((Graphics)graphics);
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{image.getImageData()};
                    if (file.endsWith(".bmp")) {
                        loader.save(file, 0);
                    } else if (file.endsWith(".gif")) {
                        loader.save(file, 2);
                    } else if (file.endsWith(".jpg") || file.endsWith(".jpeg")) {
                        loader.save(file, 4);
                    } else if (file.endsWith(".png")) {
                        loader.save(file, 5);
                    } else if (file.endsWith(".tiff")) {
                        loader.save(file, 6);
                    } else {
                        file = String.valueOf(file) + ".bmp";
                        loader.save(file, 0);
                    }
                    image.dispose();
                    gc.dispose();
                }
            }
            catch (Exception exception) {
                rootEditPart.getZoomManager().setZoom(zoom);
            }
        }
        finally {
            rootEditPart.getZoomManager().setZoom(zoom);
        }
    }
}

