/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.activitydiagram.figure;

import net.java.amateras.uml.activitydiagram.model.ObjectModel;
import net.java.amateras.uml.figure.EntityFigure;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class ObjectFigure
extends RectangleFigure
implements EntityFigure {
    private Label objectName = new Label();
    private Label stereoType = new Label();
    private Label objectState = new Label();

    public ObjectFigure() {
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.add((IFigure)this.stereoType, BorderLayout.TOP);
        this.add((IFigure)this.objectName, BorderLayout.CENTER);
        this.add((IFigure)this.objectState, BorderLayout.BOTTOM);
        this.add((IFigure)ObjectFigure.createSpacer(), BorderLayout.LEFT);
        this.add((IFigure)ObjectFigure.createSpacer(), BorderLayout.RIGHT);
    }

    private static Figure createSpacer() {
        Figure figure = new Figure();
        figure.setSize(10, 0);
        return figure;
    }

    public void updatePresentation(ObjectModel model) {
        if (model.getStereoType().length() == 0) {
            this.stereoType.setText("");
        } else {
            this.stereoType.setText("<<" + model.getStereoType() + ">>");
        }
        this.objectName.setText(model.getObjectName());
        if (model.getObjectState().length() == 0) {
            this.objectState.setText("");
        } else {
            this.objectState.setText("[" + model.getObjectState() + "]");
        }
        this.objectName.setBackgroundColor(model.getBackgroundColor());
        this.objectName.setForegroundColor(model.getForegroundColor());
        this.objectState.setBackgroundColor(model.getBackgroundColor());
        this.objectState.setForegroundColor(model.getForegroundColor());
        this.stereoType.setBackgroundColor(model.getBackgroundColor());
        this.stereoType.setForegroundColor(model.getForegroundColor());
        this.setBackgroundColor(model.getBackgroundColor());
        this.setForegroundColor(model.getForegroundColor());
    }

    @Override
    public Rectangle getCellEditorRectangle() {
        return this.objectName.getBounds().getCopy();
    }

    @Override
    public Label getLabel() {
        return this.objectName;
    }
}

