/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.activitydiagram.figure;

import net.java.amateras.uml.activitydiagram.model.VerticalPartitionModel;
import net.java.amateras.uml.figure.EntityFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class VerticalPartitionFigure
extends RectangleFigure
implements EntityFigure {
    private Label label = new Label();

    public VerticalPartitionFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.label.setBorder((Border)new LineBorder(){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                tempRect.setBounds(1.getPaintRectangle((IFigure)figure, (Insets)insets));
                if (this.getWidth() % 2 == 1) {
                    --1.tempRect.width;
                    --1.tempRect.height;
                }
                tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                graphics.setLineWidth(this.getWidth());
                if (this.getColor() != null) {
                    graphics.setForegroundColor(this.getColor());
                }
                graphics.drawLine(1.tempRect.x, 1.tempRect.y + 1.tempRect.height, 1.tempRect.x + 1.tempRect.width, 1.tempRect.y + 1.tempRect.height);
            }
        });
        this.add((IFigure)this.label);
        this.setOpaque(false);
        this.setFill(false);
    }

    public void updatePresentation(VerticalPartitionModel model) {
        this.label.setText(model.getPartitionName());
        this.setConstraint((IFigure)this.label, new Rectangle(0, 0, model.getConstraint().width, 20));
    }

    @Override
    public Rectangle getCellEditorRectangle() {
        return this.label.getBounds().getCopy();
    }

    @Override
    public Label getLabel() {
        return this.label;
    }
}

