/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram;

import net.java.amateras.uml.DiagramEditor;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.classdiagram.action.AddAttributeAction;
import net.java.amateras.uml.classdiagram.action.AddOperationAction;
import net.java.amateras.uml.classdiagram.action.AutoLayoutAction;
import net.java.amateras.uml.classdiagram.action.CopyAction;
import net.java.amateras.uml.classdiagram.action.DownAction;
import net.java.amateras.uml.classdiagram.action.PasteAction;
import net.java.amateras.uml.classdiagram.action.ShowAllAction;
import net.java.amateras.uml.classdiagram.action.ShowPublicAction;
import net.java.amateras.uml.classdiagram.action.ToggleAction;
import net.java.amateras.uml.classdiagram.action.UpAction;
import net.java.amateras.uml.classdiagram.editpart.UMLEditPartFactory;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.AggregationModel;
import net.java.amateras.uml.classdiagram.model.AssociationModel;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.CompositeModel;
import net.java.amateras.uml.classdiagram.model.DependencyModel;
import net.java.amateras.uml.classdiagram.model.GeneralizationModel;
import net.java.amateras.uml.classdiagram.model.InterfaceModel;
import net.java.amateras.uml.classdiagram.model.RealizationModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.model.AnchorModel;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class ClassDiagramEditor
extends DiagramEditor {
    private AbstractUMLEditorAction addAttributeAction = null;
    private AbstractUMLEditorAction addOperationAction = null;
    private UpAction upAction = null;
    private DownAction downAction = null;
    private CopyAction copyAction = null;
    private AutoLayoutAction autoLayoutAction = null;
    private PasteAction pasteAction = null;
    private ShowPublicAction showPublicAction = null;
    private ShowAllAction showAllAction = null;
    private ToggleAction togglePublicAttr = null;
    private ToggleAction toggleProtectedAttr = null;
    private ToggleAction togglePackageAttr = null;
    private ToggleAction togglePrivateAttr = null;
    private ToggleAction togglePublicOpe = null;
    private ToggleAction toggleProtectedOpe = null;
    private ToggleAction togglePackageOpe = null;
    private ToggleAction togglePrivateOpe = null;
    private AlignmentAction top;
    private AlignmentAction midlle;
    private AlignmentAction bottom;
    private AlignmentAction left;
    private AlignmentAction center;
    private AlignmentAction right;

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        UMLPlugin plugin = UMLPlugin.getDefault();
        PaletteGroup tools = new PaletteGroup(plugin.getResourceString("palette.tool"));
        SelectionToolEntry tool = new SelectionToolEntry();
        tools.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tools.add((PaletteEntry)tool);
        PaletteDrawer common = new PaletteDrawer(plugin.getResourceString("palette.common"));
        common.add(this.createEntityEntry(plugin.getResourceString("palette.common.note"), NoteModel.class, "icons/note.gif"));
        common.add(this.createConnectionEntry(plugin.getResourceString("palette.common.anchor"), AnchorModel.class, "icons/anchor.gif"));
        PaletteDrawer entities = new PaletteDrawer(plugin.getResourceString("palette.entity"));
        entities.add(this.createEntityEntry(plugin.getResourceString("palette.entity.class"), ClassModel.class, "icons/class.gif"));
        entities.add(this.createEntityEntry(plugin.getResourceString("palette.entity.interface"), InterfaceModel.class, "icons/interface.gif"));
        PaletteDrawer relations = new PaletteDrawer(plugin.getResourceString("palette.relation"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.relation.dependency"), DependencyModel.class, "icons/dependency.gif"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.relation.association"), AssociationModel.class, "icons/association.gif"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.relation.generalization"), GeneralizationModel.class, "icons/generalization.gif"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.relation.realization"), RealizationModel.class, "icons/realization.gif"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.relation.aggregation"), AggregationModel.class, "icons/aggregation.gif"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.relation.composition"), CompositeModel.class, "icons/composition.gif"));
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)common);
        root.add((PaletteEntry)entities);
        root.add((PaletteEntry)relations);
        return root;
    }

    @Override
    protected RootModel createInitializeModel() {
        RootModel model = new RootModel();
        model.setShowIcon(true);
        model.setBackgroundColor(UMLClassFigure.classColor.getRGB());
        model.setForegroundColor(ColorConstants.black.getRGB());
        return model;
    }

    @Override
    protected String getDiagramType() {
        return "class";
    }

    protected void createActions() {
        super.createActions();
        this.pasteAction = new PasteAction(this);
        this.getActionRegistry().registerAction((IAction)this.pasteAction);
        this.getSelectionActions().add(this.pasteAction.getId());
        this.copyAction = new CopyAction(this, this.pasteAction);
        this.getActionRegistry().registerAction((IAction)this.copyAction);
        this.getSelectionActions().add(this.copyAction.getId());
    }

    @Override
    protected void createDiagramAction(GraphicalViewer viewer) {
        this.addAttributeAction = new AddAttributeAction(viewer.getEditDomain().getCommandStack(), viewer);
        this.addOperationAction = new AddOperationAction(viewer.getEditDomain().getCommandStack(), viewer);
        this.upAction = new UpAction(viewer.getEditDomain().getCommandStack(), viewer);
        this.downAction = new DownAction(viewer.getEditDomain().getCommandStack(), viewer);
        this.autoLayoutAction = new AutoLayoutAction(viewer);
        this.showPublicAction = new ShowPublicAction(viewer);
        this.showAllAction = new ShowAllAction(viewer);
        this.togglePublicAttr = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.attr.public"), viewer, "attr", Visibility.PUBLIC);
        this.toggleProtectedAttr = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.attr.protected"), viewer, "attr", Visibility.PROTECTED);
        this.togglePackageAttr = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.attr.package"), viewer, "attr", Visibility.PACKAGE);
        this.togglePrivateAttr = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.attr.private"), viewer, "attr", Visibility.PRIVATE);
        this.togglePublicOpe = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.ope.public"), viewer, "operation", Visibility.PUBLIC);
        this.toggleProtectedOpe = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.ope.protected"), viewer, "operation", Visibility.PROTECTED);
        this.togglePackageOpe = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.ope.package"), viewer, "operation", Visibility.PACKAGE);
        this.togglePrivateOpe = new ToggleAction(UMLPlugin.getDefault().getResourceString("filter.ope.private"), viewer, "operation", Visibility.PRIVATE);
    }

    @Override
    protected void fillDiagramPopupMenu(MenuManager manager) {
        manager.add((IContributionItem)new Separator("align"));
        manager.add((IAction)this.autoLayoutAction);
        this.top = new AlignmentAction((IWorkbenchPart)this, 8);
        this.top.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.midlle = new AlignmentAction((IWorkbenchPart)this, 16);
        this.midlle.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.bottom = new AlignmentAction((IWorkbenchPart)this, 32);
        this.bottom.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.left = new AlignmentAction((IWorkbenchPart)this, 1);
        this.left.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.center = new AlignmentAction((IWorkbenchPart)this, 2);
        this.center.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.right = new AlignmentAction((IWorkbenchPart)this, 4);
        this.right.setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        this.getActionRegistry().registerAction((IAction)this.top);
        this.getActionRegistry().registerAction((IAction)this.midlle);
        this.getActionRegistry().registerAction((IAction)this.bottom);
        this.getActionRegistry().registerAction((IAction)this.left);
        this.getActionRegistry().registerAction((IAction)this.center);
        this.getActionRegistry().registerAction((IAction)this.right);
        MenuManager alignmenu = new MenuManager(UMLPlugin.getDefault().getResourceString("menu.align"));
        alignmenu.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_top"));
        alignmenu.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_middle"));
        alignmenu.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_bottom"));
        alignmenu.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_left"));
        alignmenu.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_center"));
        alignmenu.add(this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_right"));
        manager.add((IContributionItem)alignmenu);
        MenuManager filtermenu = new MenuManager(UMLPlugin.getDefault().getResourceString("menu.filter"));
        filtermenu.add((IAction)this.showPublicAction);
        filtermenu.add((IAction)this.showAllAction);
        filtermenu.add((IContributionItem)new Separator());
        filtermenu.add((IAction)this.togglePublicAttr);
        filtermenu.add((IAction)this.toggleProtectedAttr);
        filtermenu.add((IAction)this.togglePackageAttr);
        filtermenu.add((IAction)this.togglePrivateAttr);
        filtermenu.add((IContributionItem)new Separator());
        filtermenu.add((IAction)this.togglePublicOpe);
        filtermenu.add((IAction)this.toggleProtectedOpe);
        filtermenu.add((IAction)this.togglePackageOpe);
        filtermenu.add((IAction)this.togglePrivateOpe);
        manager.add((IContributionItem)filtermenu);
        manager.add((IContributionItem)new Separator("add"));
        manager.add((IAction)this.addAttributeAction);
        manager.add((IAction)this.addOperationAction);
        manager.add((IAction)this.upAction);
        manager.add((IAction)this.downAction);
        manager.add((IContributionItem)new Separator("copy"));
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
    }

    @Override
    protected void updateDiagramAction(ISelection selection) {
        this.addAttributeAction.update((IStructuredSelection)selection);
        this.addOperationAction.update((IStructuredSelection)selection);
        this.upAction.update((IStructuredSelection)selection);
        this.downAction.update((IStructuredSelection)selection);
        this.autoLayoutAction.update((IStructuredSelection)selection);
        this.top.update();
        this.midlle.update();
        this.bottom.update();
        this.left.update();
        this.center.update();
        this.right.update();
        this.showPublicAction.update((IStructuredSelection)selection);
        this.showAllAction.update((IStructuredSelection)selection);
        this.togglePackageAttr.update((IStructuredSelection)selection);
        this.togglePackageOpe.update((IStructuredSelection)selection);
        this.togglePrivateAttr.update((IStructuredSelection)selection);
        this.togglePrivateOpe.update((IStructuredSelection)selection);
        this.toggleProtectedAttr.update((IStructuredSelection)selection);
        this.toggleProtectedOpe.update((IStructuredSelection)selection);
        this.togglePublicAttr.update((IStructuredSelection)selection);
        this.togglePublicOpe.update((IStructuredSelection)selection);
    }

    @Override
    protected EditPartFactory createEditPartFactory() {
        return new UMLEditPartFactory();
    }
}

