/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.action;

import java.util.List;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.classdiagram.editpart.AttributeEditPart;
import net.java.amateras.uml.classdiagram.editpart.ClassEditPart;
import net.java.amateras.uml.classdiagram.editpart.InterfaceEditPart;
import net.java.amateras.uml.classdiagram.editpart.OperationEditPart;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractAttributeAndOperationAction
extends AbstractUMLEditorAction {
    protected CommandStack stack;
    protected AbstractUMLEditPart targetPart;

    public AbstractAttributeAndOperationAction(String name, CommandStack stack, GraphicalViewer viewer) {
        super(name, viewer);
        this.stack = stack;
    }

    @Override
    public void update(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj != null && obj instanceof OperationEditPart) {
            this.setEnabled(true);
            this.targetPart = (OperationEditPart)obj;
        } else if (obj != null && obj instanceof AttributeEditPart) {
            this.setEnabled(true);
            this.targetPart = (AttributeEditPart)obj;
        } else {
            this.setEnabled(false);
            this.targetPart = null;
        }
    }

    protected static int getFigureCount(AbstractUMLEditPart targetPart) {
        AbstractUMLModel targetModel = (AbstractUMLModel)targetPart.getModel();
        AbstractUMLEntityModel parent = targetModel.getParent();
        List<AbstractUMLModel> children = parent.getChildren();
        int count = 0;
        int i = 0;
        while (i < children.size()) {
            AbstractUMLModel obj = children.get(i);
            if (targetModel instanceof OperationModel) {
                if (obj instanceof OperationModel) {
                    ++count;
                }
            } else if (targetModel instanceof AttributeModel && obj instanceof AttributeModel) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected static int getFigureIndex(AbstractUMLEditPart targetPart) {
        AbstractUMLModel targetModel = (AbstractUMLModel)targetPart.getModel();
        AbstractUMLEntityModel parent = targetModel.getParent();
        List<AbstractUMLModel> children = parent.getChildren();
        int count = 0;
        int i = 0;
        while (i < children.size()) {
            AbstractUMLModel obj = children.get(i);
            if (obj == targetModel) break;
            if (targetModel instanceof OperationModel) {
                if (obj instanceof OperationModel) {
                    ++count;
                }
            } else if (targetModel instanceof AttributeModel && obj instanceof AttributeModel) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected static UMLClassFigure getFigure(AbstractUMLEditPart targetPart) {
        EditPart parent = targetPart.getParent();
        if (parent instanceof ClassEditPart) {
            return (UMLClassFigure)((ClassEditPart)parent).getFigure();
        }
        if (parent instanceof InterfaceEditPart) {
            return (UMLClassFigure)((InterfaceEditPart)parent).getFigure();
        }
        return null;
    }
}

