/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.action;

import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.action.AbstractAttributeAndOperationAction;
import net.java.amateras.uml.classdiagram.editpart.ClassEditPart;
import net.java.amateras.uml.classdiagram.editpart.InterfaceEditPart;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DownAction
extends AbstractAttributeAndOperationAction {
    public DownAction(CommandStack stack, GraphicalViewer viewer) {
        super(UMLPlugin.getDefault().getResourceString("menu.down"), stack, viewer);
    }

    public void run() {
        this.stack.execute((Command)new DownCommand(this.targetPart));
    }

    @Override
    public void update(IStructuredSelection sel) {
        super.update(sel);
        if (this.isEnabled() && DownAction.getFigureIndex(this.targetPart) == DownAction.getFigureCount(this.targetPart) - 1) {
            this.setEnabled(false);
            this.targetPart = null;
        }
    }

    private static class DownCommand
    extends Command {
        private int orgIndex;
        private int figureIndex;
        private AbstractUMLEditPart targetPart;

        public DownCommand(AbstractUMLEditPart targetPart) {
            this.targetPart = targetPart;
        }

        private UMLClassFigure getFigure() {
            EditPart parent = this.targetPart.getParent();
            if (parent instanceof ClassEditPart) {
                return (UMLClassFigure)((ClassEditPart)parent).getFigure();
            }
            if (parent instanceof InterfaceEditPart) {
                return (UMLClassFigure)((InterfaceEditPart)parent).getFigure();
            }
            return null;
        }

        public void execute() {
            int refIndex;
            AbstractUMLModel targetModel = (AbstractUMLModel)this.targetPart.getModel();
            AbstractUMLEntityModel parent = targetModel.getParent();
            List<AbstractUMLModel> children = parent.getChildren();
            this.figureIndex = DownAction.getFigureIndex(this.targetPart);
            this.orgIndex = -1;
            if (targetModel instanceof OperationModel) {
                refIndex = -1;
                int i = 0;
                while (i < children.size()) {
                    AbstractUMLModel child = children.get(i);
                    if (child instanceof OperationModel) {
                        if (child == targetModel) {
                            this.orgIndex = i;
                        } else if (this.orgIndex != -1) {
                            refIndex = i;
                            children.remove(targetModel);
                            children.add(refIndex, targetModel);
                            break;
                        }
                    }
                    ++i;
                }
            } else if (targetModel instanceof AttributeModel) {
                refIndex = -1;
                int i = 0;
                while (i < children.size()) {
                    AbstractUMLModel child = children.get(i);
                    if (child instanceof AttributeModel) {
                        if (child == targetModel) {
                            this.orgIndex = i;
                        } else if (this.orgIndex != -1) {
                            refIndex = i;
                            children.remove(targetModel);
                            children.add(refIndex, targetModel);
                            break;
                        }
                    }
                    ++i;
                }
            }
            UMLClassFigure figure = this.getFigure();
            if (targetModel instanceof OperationModel) {
                figure.moveOperation(this.figureIndex, false);
            } else {
                figure.moveAttribute(this.figureIndex, false);
            }
        }

        public void undo() {
            AbstractUMLModel targetModel = (AbstractUMLModel)this.targetPart.getModel();
            UMLClassFigure figure = this.getFigure();
            if (targetModel instanceof OperationModel) {
                figure.moveOperation(this.figureIndex + 1, true);
            } else {
                figure.moveAttribute(this.figureIndex + 1, true);
            }
            AbstractUMLEntityModel parent = targetModel.getParent();
            List<AbstractUMLModel> children = parent.getChildren();
            children.remove(targetModel);
            children.add(this.orgIndex, targetModel);
            this.targetPart.refresh();
        }
    }
}

