/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.action;

import java.util.HashMap;
import java.util.Map;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.classdiagram.editpart.AttributeEditPart;
import net.java.amateras.uml.classdiagram.editpart.OperationEditPart;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.editpart.RootEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ToggleAction
extends AbstractUMLEditorAction {
    public static final String ATTRIBUTE = "attr";
    public static final String OPERATION = "operation";
    private CommandStack stack;
    private AbstractUMLEntityModel target;
    private String type;
    private Visibility visibility;

    public ToggleAction(String name, GraphicalViewer viewer, String type, Visibility visibility) {
        super(name, 2, viewer);
        this.stack = viewer.getEditDomain().getCommandStack();
        this.type = type;
        this.visibility = visibility;
        this.setChecked(true);
    }

    public void run() {
        this.stack.execute((Command)new TogglePresentCommand(this.target));
    }

    @Override
    public void update(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj != null && obj instanceof AbstractUMLEntityEditPart) {
            this.target = (AbstractUMLEntityModel)((AbstractUMLEntityEditPart)obj).getModel();
            this.setEnabled(true);
        } else if (obj != null && obj instanceof OperationEditPart) {
            this.target = (AbstractUMLEntityModel)((OperationEditPart)obj).getParent().getModel();
            this.setEnabled(true);
        } else if (obj != null && obj instanceof AttributeEditPart) {
            this.target = (AbstractUMLEntityModel)((AttributeEditPart)obj).getParent().getModel();
            this.setEnabled(true);
        } else if (obj != null && obj instanceof RootEditPart) {
            this.target = (RootModel)((RootEditPart)obj).getModel();
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
            this.target = null;
        }
        this.setChecked(this.calcChecked());
    }

    private boolean calcChecked() {
        if (this.target == null) {
            return false;
        }
        Map<String, Boolean> map = this.target.getFilterProperty();
        if (map == null) {
            this.target.setFilterProperty(new HashMap<String, Boolean>());
            return true;
        }
        if (!map.containsKey(String.valueOf(this.type) + this.visibility)) {
            return true;
        }
        Boolean value = map.get(String.valueOf(this.type) + this.visibility);
        return value == false;
    }

    private class TogglePresentCommand
    extends Command {
        private boolean oldValue;
        private AbstractUMLEntityModel target;

        public TogglePresentCommand(AbstractUMLEntityModel target) {
            this.target = target;
        }

        public void execute() {
            Map<String, Boolean> map = this.target.getFilterProperty();
            if (!map.containsKey(String.valueOf(ToggleAction.this.type) + ToggleAction.this.visibility)) {
                this.oldValue = false;
                map.put(String.valueOf(ToggleAction.this.type) + ToggleAction.this.visibility, new Boolean(true));
            } else {
                Boolean value = map.get(String.valueOf(ToggleAction.this.type) + ToggleAction.this.visibility);
                this.oldValue = value;
                map.put(String.valueOf(ToggleAction.this.type) + ToggleAction.this.visibility, new Boolean(value == false));
            }
            this.target.setFilterProperty(map);
        }

        public void undo() {
            Map<String, Boolean> map = this.target.getFilterProperty();
            map.put(String.valueOf(ToggleAction.this.type) + ToggleAction.this.visibility, new Boolean(this.oldValue));
            this.target.setFilterProperty(map);
        }
    }
}

