/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.action;

import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.action.AbstractAttributeAndOperationAction;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;

public class UpAction
extends AbstractAttributeAndOperationAction {
    public UpAction(CommandStack stack, GraphicalViewer viewer) {
        super(UMLPlugin.getDefault().getResourceString("menu.up"), stack, viewer);
    }

    public void run() {
        this.stack.execute((Command)new UpCommand(this.targetPart));
    }

    @Override
    public void update(IStructuredSelection sel) {
        super.update(sel);
        if (this.isEnabled() && UpAction.getFigureIndex(this.targetPart) == 0) {
            this.setEnabled(false);
            this.targetPart = null;
        }
    }

    private class UpCommand
    extends Command {
        private int orgIndex;
        private int figureIndex;
        private AbstractUMLEditPart targetPart;

        public UpCommand(AbstractUMLEditPart targetPart) {
            this.targetPart = targetPart;
        }

        public void execute() {
            int refIndex;
            AbstractUMLModel targetModel = (AbstractUMLModel)this.targetPart.getModel();
            AbstractUMLEntityModel parent = targetModel.getParent();
            List<AbstractUMLModel> children = parent.getChildren();
            this.orgIndex = 0;
            this.figureIndex = UpAction.getFigureIndex(this.targetPart);
            if (targetModel instanceof OperationModel) {
                refIndex = 0;
                int i = 0;
                while (i < children.size()) {
                    AbstractUMLModel child = children.get(i);
                    if (child instanceof OperationModel) {
                        if (child == targetModel) {
                            children.remove(targetModel);
                            children.add(refIndex, targetModel);
                            this.orgIndex = i;
                            break;
                        }
                        refIndex = i;
                    }
                    ++i;
                }
            } else if (targetModel instanceof AttributeModel) {
                refIndex = 0;
                int i = 0;
                while (i < children.size()) {
                    AbstractUMLModel child = children.get(i);
                    if (child instanceof AttributeModel) {
                        if (child == targetModel) {
                            children.remove(targetModel);
                            children.add(refIndex, targetModel);
                            this.orgIndex = i;
                            break;
                        }
                        refIndex = i;
                    }
                    ++i;
                }
            }
            UMLClassFigure figure = UpAction.getFigure(this.targetPart);
            if (targetModel instanceof OperationModel) {
                figure.moveOperation(this.figureIndex, true);
            } else {
                figure.moveAttribute(this.figureIndex, true);
            }
        }

        public void undo() {
            AbstractUMLModel targetModel = (AbstractUMLModel)this.targetPart.getModel();
            UMLClassFigure figure = UpAction.getFigure(this.targetPart);
            if (targetModel instanceof OperationModel) {
                figure.moveOperation(this.figureIndex - 1, false);
            } else {
                figure.moveAttribute(this.figureIndex - 1, false);
            }
            AbstractUMLEntityModel parent = targetModel.getParent();
            List<AbstractUMLModel> children = parent.getChildren();
            children.remove(targetModel);
            children.add(this.orgIndex, targetModel);
            this.targetPart.refresh();
        }
    }
}

