/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.figure.AttributeLabel;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public class AttributeEditPart
extends AbstractUMLEditPart {
    private AttributeDirectEditManager directManager = null;

    protected IFigure createFigure() {
        AttributeLabel label = new AttributeLabel();
        AttributeModel model = (AttributeModel)this.getModel();
        this.updateLabel(label, model);
        return label;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AttributeComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new AttributeDirectEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        AttributeLabel label = (AttributeLabel)this.getFigure();
        AttributeModel model = (AttributeModel)this.getModel();
        this.updateLabel(label, model);
        super.propertyChange(arg0);
    }

    private void updateLabel(AttributeLabel label, AttributeModel model) {
        if (model.isShowIcon()) {
            if (model.getVisibility().equals(Visibility.PUBLIC)) {
                label.setIcon(UMLPlugin.getImageDescriptor("icons/field_public.gif").createImage());
            } else if (model.getVisibility().equals(Visibility.PRIVATE)) {
                label.setIcon(UMLPlugin.getImageDescriptor("icons/field_private.gif").createImage());
            } else if (model.getVisibility().equals(Visibility.PROTECTED)) {
                label.setIcon(UMLPlugin.getImageDescriptor("icons/field_protected.gif").createImage());
            } else if (model.getVisibility().equals(Visibility.PACKAGE)) {
                label.setIcon(UMLPlugin.getImageDescriptor("icons/field_default.gif").createImage());
            }
            label.setText(model.toString());
        } else {
            String visibility = " ";
            if (model.getVisibility().equals(Visibility.PUBLIC)) {
                visibility = "+";
            } else if (model.getVisibility().equals(Visibility.PRIVATE)) {
                visibility = "-";
            } else if (model.getVisibility().equals(Visibility.PROTECTED)) {
                visibility = "#";
            }
            label.setText(String.valueOf(visibility) + model.toString());
        }
        label.setUnderline(model.isStatic());
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit") || req.getType().equals("open")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new AttributeDirectEditManager();
        }
        this.directManager.show();
    }

    private class AttributeCellEditorLocator
    implements CellEditorLocator {
        private AttributeCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = AttributeEditPart.this.getFigure().getBounds().getCopy();
            AttributeEditPart.this.figure.translateToAbsolute((Translatable)rect);
            if (((AttributeModel)AttributeEditPart.this.getModel()).isShowIcon()) {
                text.setBounds(rect.x + 16, rect.y, rect.width - 16, rect.height);
            } else {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private class AttributeComponentEditPolicy
    extends ComponentEditPolicy {
        private AttributeComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setParentModel(this.getHost().getParent().getModel());
            command.setTargetModel(this.getHost().getModel());
            return command;
        }
    }

    private class AttributeDirectEditManager
    extends DirectEditManager {
        public AttributeDirectEditManager() {
            super((GraphicalEditPart)AttributeEditPart.this, TextCellEditor.class, (CellEditorLocator)new AttributeCellEditorLocator());
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((AttributeModel)AttributeEditPart.this.getModel()).toString());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class AttributeDirectEditPolicy
    extends DirectEditPolicy {
        private AttributeDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            String value = (String)request.getCellEditor().getValue();
            String[] values = value.split(":");
            command.setName(values[0].trim());
            if (values.length > 1) {
                command.setType(values[1].trim());
            }
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }

    private class DeleteCommand
    extends Command {
        private AbstractUMLEntityModel parent;
        private AttributeModel model;

        private DeleteCommand() {
        }

        public void execute() {
            this.parent.removeChild(this.model);
        }

        public void setParentModel(Object root) {
            this.parent = (AbstractUMLEntityModel)root;
        }

        public void setTargetModel(Object model) {
            this.model = (AttributeModel)model;
        }

        public void undo() {
            this.parent.addChild(this.model);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldName;
        private String oldType;
        private String newName;
        private String newType;

        private DirectEditCommand() {
        }

        public void execute() {
            AttributeModel model = (AttributeModel)AttributeEditPart.this.getModel();
            this.oldName = model.getName();
            this.oldType = model.getType();
            model.setName(this.newName);
            if (this.newType != null) {
                model.setType(this.newType);
            }
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void setType(String type) {
            this.newType = type;
        }

        public void undo() {
            AttributeModel model = (AttributeModel)AttributeEditPart.this.getModel();
            model.setName(this.oldName);
            model.setName(this.oldType);
        }
    }
}

