/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.editpart.FilterUtil;
import net.java.amateras.uml.classdiagram.editpart.RenameUtil;
import net.java.amateras.uml.classdiagram.figure.UMLClassFigure;
import net.java.amateras.uml.classdiagram.model.CommonEntityModel;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public abstract class CommonEntityEditPart
extends AbstractUMLEntityEditPart {
    private EntityDirectEditManager directManager;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ClassNameDirectEditPolicy());
    }

    protected List<AbstractUMLModel> getModelChildren() {
        CommonEntityModel model = (CommonEntityModel)this.getModel();
        return FilterUtil.getFilteredChildren(model);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("_entityName")) {
            RenameUtil.rename((String)evt.getOldValue(), (String)evt.getNewValue(), (RootModel)this.getParent().getModel());
        } else if (evt.getPropertyName().equals("_children")) {
            this.refreshChildren();
        } else if (evt.getPropertyName().equals("_filter")) {
            ArrayList list = new ArrayList(this.getChildren());
            for (EditPart element : list) {
                this.removeChild(element);
            }
            this.refreshChildren();
        }
    }

    protected IFigure createFigure() {
        CommonEntityModel model = (CommonEntityModel)this.getModel();
        UMLClassFigure figure = this.getClassFigure();
        figure.setClassName(this.showSimpleName() ? model.getSimpleName() : model.getName());
        figure.setStereoType(model.getStereoType());
        figure.setBackgroundColor(model.getBackgroundColor());
        figure.setForegroundColor(model.getForegroundColor());
        return figure;
    }

    protected abstract UMLClassFigure getClassFigure();

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        UMLClassFigure figure = (UMLClassFigure)this.getFigure();
        CommonEntityModel model = (CommonEntityModel)this.getModel();
        figure.setClassName(this.showSimpleName() ? model.getSimpleName() : model.getName());
        figure.setStereoType(model.getStereoType());
        figure.setBackgroundColor(model.getBackgroundColor());
        figure.setForegroundColor(model.getForegroundColor());
    }

    private boolean showSimpleName() {
        return UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.classdiagram.simplename");
    }

    @Override
    public void performRequest(Request req) {
        if (this.getModel() instanceof EntityModel && (req.getType().equals("direct edit") || req.getType().equals("open"))) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new EntityDirectEditManager((GraphicalEditPart)this);
        }
        this.directManager.show();
    }

    private class ClassNameDirectEditCommand
    extends Command {
        private String oldName;
        private String newName;

        private ClassNameDirectEditCommand() {
        }

        public void execute() {
            CommonEntityModel model = (CommonEntityModel)CommonEntityEditPart.this.getModel();
            String string = this.oldName = CommonEntityEditPart.this.showSimpleName() ? model.getSimpleName() : model.getName();
            if (CommonEntityEditPart.this.showSimpleName()) {
                model.setSimpleName(this.newName);
            } else {
                model.setName(this.newName);
            }
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void undo() {
            CommonEntityModel model = (CommonEntityModel)CommonEntityEditPart.this.getModel();
            if (CommonEntityEditPart.this.showSimpleName()) {
                model.setSimpleName(this.oldName);
            } else {
                model.setName(this.oldName);
            }
        }
    }

    private class ClassNameDirectEditPolicy
    extends DirectEditPolicy {
        private ClassNameDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest directeditrequest) {
            ClassNameDirectEditCommand command = new ClassNameDirectEditCommand();
            command.setName((String)directeditrequest.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest directeditrequest) {
        }
    }

    private class EntityCellEditorLocator
    implements CellEditorLocator {
        private EntityCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            EntityFigure figure = (EntityFigure)CommonEntityEditPart.this.getFigure();
            Text text = (Text)celleditor.getControl();
            Rectangle rect = figure.getCellEditorRectangle();
            figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class EntityDirectEditManager
    extends DirectEditManager {
        public EntityDirectEditManager(GraphicalEditPart editPart) {
            super(editPart, TextCellEditor.class, (CellEditorLocator)new EntityCellEditorLocator());
        }

        protected void initCellEditor() {
            CommonEntityModel model = (CommonEntityModel)CommonEntityEditPart.this.getModel();
            this.getCellEditor().setValue((Object)(CommonEntityEditPart.this.showSimpleName() ? model.getSimpleName() : model.getName()));
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }
}

