/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.editpart;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;

public class FilterUtil {
    public static List<AbstractUMLModel> getFilteredChildren(AbstractUMLEntityModel model) {
        ArrayList<AbstractUMLModel> rv = new ArrayList<AbstractUMLModel>();
        rv.addAll(FilterUtil.getAttribute(model));
        rv.addAll(FilterUtil.getOperation(model));
        return rv;
    }

    private static List<AttributeModel> getAttribute(AbstractUMLEntityModel model) {
        ArrayList<AttributeModel> rv = new ArrayList<AttributeModel>();
        List<AbstractUMLModel> children = model.getChildren();
        Map<String, Boolean> map = model.getFilterProperty();
        boolean v_public = FilterUtil.isShow("attr" + Visibility.PUBLIC, map);
        boolean v_protected = FilterUtil.isShow("attr" + Visibility.PROTECTED, map);
        boolean v_package = FilterUtil.isShow("attr" + Visibility.PACKAGE, map);
        boolean v_private = FilterUtil.isShow("attr" + Visibility.PRIVATE, map);
        for (AbstractUMLModel element : children) {
            if (!(element instanceof AttributeModel)) continue;
            AttributeModel a = (AttributeModel)element;
            if (v_public && a.getVisibility().equals(Visibility.PUBLIC)) {
                rv.add(a);
                continue;
            }
            if (v_protected && a.getVisibility().equals(Visibility.PROTECTED)) {
                rv.add(a);
                continue;
            }
            if (v_package && a.getVisibility().equals(Visibility.PACKAGE)) {
                rv.add(a);
                continue;
            }
            if (!v_private || !a.getVisibility().equals(Visibility.PRIVATE)) continue;
            rv.add(a);
        }
        return rv;
    }

    private static List<OperationModel> getOperation(AbstractUMLEntityModel model) {
        ArrayList<OperationModel> rv = new ArrayList<OperationModel>();
        List<AbstractUMLModel> children = model.getChildren();
        Map<String, Boolean> map = model.getFilterProperty();
        boolean v_public = FilterUtil.isShow("operation" + Visibility.PUBLIC, map);
        boolean v_protected = FilterUtil.isShow("operation" + Visibility.PROTECTED, map);
        boolean v_package = FilterUtil.isShow("operation" + Visibility.PACKAGE, map);
        boolean v_private = FilterUtil.isShow("operation" + Visibility.PRIVATE, map);
        for (AbstractUMLModel element : children) {
            if (!(element instanceof OperationModel)) continue;
            OperationModel a = (OperationModel)element;
            if (v_public && a.getVisibility().equals(Visibility.PUBLIC)) {
                rv.add(a);
                continue;
            }
            if (v_protected && a.getVisibility().equals(Visibility.PROTECTED)) {
                rv.add(a);
                continue;
            }
            if (v_package && a.getVisibility().equals(Visibility.PACKAGE)) {
                rv.add(a);
                continue;
            }
            if (!v_private || !a.getVisibility().equals(Visibility.PRIVATE)) continue;
            rv.add(a);
        }
        return rv;
    }

    private static boolean isShow(String key, Map<String, Boolean> map) {
        if (map == null || !map.containsKey(key)) {
            return true;
        }
        Boolean bool = map.get(key);
        return bool == false;
    }
}

