/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.figure.OperationLabel;
import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Text;

public class OperationEditPart
extends AbstractUMLEditPart {
    private OperationDirectEditManager directManager = null;
    private Font normal = null;
    private Font italic = null;

    protected IFigure createFigure() {
        OperationLabel label = new OperationLabel();
        OperationModel model = (OperationModel)this.getModel();
        Font font = ((AbstractGraphicalEditPart)this.getParent()).getFigure().getFont();
        FontData fontData = font.getFontData()[0];
        this.normal = new Font(null, fontData.getName(), fontData.getHeight(), 0);
        this.italic = new Font(null, fontData.getName(), fontData.getHeight(), 2);
        this.updateLabel(label, model);
        return label;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new OperationComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new OperationDirectEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        OperationLabel label = (OperationLabel)this.getFigure();
        OperationModel model = (OperationModel)this.getModel();
        this.updateLabel(label, model);
        super.propertyChange(arg0);
    }

    private void updateLabel(OperationLabel label, OperationModel model) {
        if (model.isShowIcon()) {
            if (model.getVisibility().equals(Visibility.PUBLIC)) {
                if (model.isConstructor()) {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/const_public.gif").createImage());
                } else {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/method_public.gif").createImage());
                }
            } else if (model.getVisibility().equals(Visibility.PRIVATE)) {
                if (model.isConstructor()) {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/const_private.gif").createImage());
                } else {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/method_private.gif").createImage());
                }
            } else if (model.getVisibility().equals(Visibility.PROTECTED)) {
                if (model.isConstructor()) {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/const_protected.gif").createImage());
                } else {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/method_protected.gif").createImage());
                }
            } else if (model.getVisibility().equals(Visibility.PACKAGE)) {
                if (model.isConstructor()) {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/const_default.gif").createImage());
                } else {
                    label.setIcon(UMLPlugin.getImageDescriptor("icons/method_default.gif").createImage());
                }
            }
            label.setText(this.getOperationText(model));
        } else {
            String visibility = " ";
            if (model.getVisibility().equals(Visibility.PUBLIC)) {
                visibility = "+";
            } else if (model.getVisibility().equals(Visibility.PRIVATE)) {
                visibility = "-";
            } else if (model.getVisibility().equals(Visibility.PROTECTED)) {
                visibility = "#";
            }
            label.setText(String.valueOf(visibility) + this.getOperationText(model));
        }
        if (model.isAbstract()) {
            label.setFont(this.italic);
        } else {
            label.setFont(this.normal);
        }
        label.setUnderline(model.isStatic());
    }

    private String getOperationText(OperationModel model) {
        if (this.showParameterName()) {
            return model.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(model.getName());
        sb.append("(");
        int i = 0;
        while (i < model.getParams().size()) {
            if (i != 0) {
                sb.append(", ");
            }
            Argument arg = model.getParams().get(i);
            sb.append(arg.getType());
            ++i;
        }
        sb.append(")");
        if (!model.isConstructor()) {
            sb.append(": ");
            sb.append(model.getType());
        }
        return sb.toString();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.normal.dispose();
        this.italic.dispose();
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit") || req.getType().equals("open")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new OperationDirectEditManager();
        }
        this.directManager.show();
    }

    private boolean showParameterName() {
        return UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.classdiagram.show_parameter_name");
    }

    private class DeleteCommand
    extends Command {
        private AbstractUMLEntityModel parent;
        private OperationModel model;

        private DeleteCommand() {
        }

        public void execute() {
            this.parent.removeChild(this.model);
        }

        public void setParentModel(Object root) {
            this.parent = (AbstractUMLEntityModel)root;
        }

        public void setTargetModel(Object model) {
            this.model = (OperationModel)model;
        }

        public void undo() {
            this.parent.addChild(this.model);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldName;
        private String oldType;
        private List<Argument> oldParams;
        private String newName;
        private String newType;
        private List<Argument> newParams;

        private DirectEditCommand() {
        }

        public void execute() {
            OperationModel model = (OperationModel)OperationEditPart.this.getModel();
            this.oldName = model.getName();
            this.oldType = model.getType();
            this.oldParams = model.getParams();
            model.setName(this.newName);
            if (this.newType != null) {
                model.setType(this.newType);
            }
            if (this.newParams != null) {
                model.setParams(this.newParams);
            }
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void setType(String type) {
            this.newType = type;
        }

        public void setParams(List<Argument> params) {
            this.newParams = params;
        }

        public void undo() {
            OperationModel model = (OperationModel)OperationEditPart.this.getModel();
            model.setName(this.oldName);
            model.setType(this.oldType);
            model.setParams(this.oldParams);
        }
    }

    private class OperationCellEditorLocator
    implements CellEditorLocator {
        private OperationCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = OperationEditPart.this.getFigure().getBounds().getCopy();
            OperationEditPart.this.figure.translateToAbsolute((Translatable)rect);
            if (((OperationModel)OperationEditPart.this.getModel()).isShowIcon()) {
                text.setBounds(rect.x + 16, rect.y, rect.width - 16, rect.height);
            } else {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private class OperationComponentEditPolicy
    extends ComponentEditPolicy {
        private OperationComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setParentModel(this.getHost().getParent().getModel());
            command.setTargetModel(this.getHost().getModel());
            return command;
        }
    }

    private class OperationDirectEditManager
    extends DirectEditManager {
        public OperationDirectEditManager() {
            super((GraphicalEditPart)OperationEditPart.this, TextCellEditor.class, (CellEditorLocator)new OperationCellEditorLocator());
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)OperationEditPart.this.getOperationText((OperationModel)OperationEditPart.this.getModel()));
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class OperationDirectEditPolicy
    extends DirectEditPolicy {
        private OperationDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            String value = (String)request.getCellEditor().getValue();
            String[] values = value.split("\\(");
            command.setName(values[0].trim());
            if (values.length > 1) {
                String[] values2 = values[1].split("\\)");
                if (values2.length > 1) {
                    String[] params = values2[0].split(",");
                    ArrayList<Argument> newParams = new ArrayList<Argument>();
                    int i = 0;
                    while (i < params.length) {
                        String[] param = params[i].split(":");
                        if (!param[0].trim().equals("")) {
                            Argument arg = new Argument();
                            arg.setName(param[0].trim());
                            if (param.length > 1) {
                                arg.setType(param[1].trim());
                            } else {
                                arg.setType("int");
                            }
                            newParams.add(arg);
                        }
                        ++i;
                    }
                    command.setParams(newParams);
                } else {
                    command.setParams(new ArrayList<Argument>());
                }
                if (values2.length > 1 && values2[1].trim().startsWith(":")) {
                    command.setType(values2[1].trim().substring(1).trim());
                }
            }
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

