/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.figure;

import net.java.amateras.uml.classdiagram.model.AggregationModel;
import net.java.amateras.uml.figure.PresentationFigure;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.widgets.Display;

public class AggregationConnectionFigure
extends PolylineConnection
implements PresentationFigure {
    private Label labelStereoType = new Label();
    private Label labelFromMultiplicity;
    private Label labelToMultiplicity;

    public AggregationConnectionFigure(AggregationModel model) {
        if (!model.getStereoType().equals("")) {
            this.labelStereoType.setText("<<" + model.getStereoType() + ">>");
        }
        this.labelFromMultiplicity = new Label();
        this.labelFromMultiplicity.setText(model.getFromMultiplicity());
        this.labelToMultiplicity = new Label();
        this.labelToMultiplicity.setText(model.getToMultiplicity());
        this.add((IFigure)this.labelStereoType, new ConnectionLocator((Connection)this, 4));
        ConnectionEndpointLocator sourceEndpointLocator = new ConnectionEndpointLocator((Connection)this, false);
        sourceEndpointLocator.setVDistance(15);
        this.add((IFigure)this.labelFromMultiplicity, sourceEndpointLocator);
        ConnectionEndpointLocator targetEndpointLocator = new ConnectionEndpointLocator((Connection)this, true);
        targetEndpointLocator.setVDistance(15);
        this.add((IFigure)this.labelToMultiplicity, targetEndpointLocator);
        PolygonDecoration decoration = new PolygonDecoration();
        PointList decorationPointList = new PointList();
        decorationPointList.addPoint(0, 0);
        decorationPointList.addPoint(-2, 2);
        decorationPointList.addPoint(-4, 0);
        decorationPointList.addPoint(-2, -2);
        decoration.setTemplate(decorationPointList);
        decoration.setBackgroundColor(Display.getDefault().getSystemColor(1));
        this.setTargetDecoration((RotatableDecoration)decoration);
    }

    public void update(AggregationModel model) {
        this.labelFromMultiplicity.setText(model.getFromMultiplicity());
        this.labelToMultiplicity.setText(model.getToMultiplicity());
        if (!model.getStereoType().equals("")) {
            this.labelStereoType.setText("<<" + model.getStereoType() + ">>");
        } else {
            this.labelStereoType.setText("");
        }
    }

    public Label getStereoTypeLabel() {
        return this.labelStereoType;
    }

    @Override
    public void updatePresentation(AbstractUMLModel model) {
        this.labelStereoType.setForegroundColor(model.getForegroundColor());
        this.labelFromMultiplicity.setForegroundColor(model.getForegroundColor());
        this.labelToMultiplicity.setForegroundColor(model.getForegroundColor());
        this.setForegroundColor(model.getForegroundColor());
    }
}

