/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.figure;

import java.util.List;
import net.java.amateras.uml.classdiagram.figure.AttributeLabel;
import net.java.amateras.uml.classdiagram.figure.CompartmentFigure;
import net.java.amateras.uml.classdiagram.figure.OperationLabel;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.figure.PresentationFigure;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class UMLClassFigure
extends Figure
implements EntityFigure,
PresentationFigure {
    public static Color classColor = new Color(null, 255, 255, 206);
    private Label name;
    private Label stereoType;
    private Image icon;
    private CompartmentFigure attributeFigure = new CompartmentFigure();
    private CompartmentFigure methodFigure = new CompartmentFigure();
    private Figure nameFigure;

    public UMLClassFigure(Image icon, Figure nameFigure) {
        this.nameFigure = nameFigure;
        this.name = new Label();
        this.name.setForegroundColor(ColorConstants.darkGray);
        this.name.setBorder((Border)new MarginBorder(5));
        this.name.setIcon(icon);
        this.icon = icon;
        this.stereoType = new Label();
        this.stereoType.setTextAlignment(2);
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(1));
        this.setBackgroundColor(classColor);
        this.setOpaque(true);
        nameFigure.setLayoutManager((LayoutManager)new ToolbarLayout());
        nameFigure.add((IFigure)this.name);
        this.add((IFigure)nameFigure);
        this.add((IFigure)this.attributeFigure);
        this.add((IFigure)this.methodFigure);
    }

    public void setFont(Font font) {
        this.name.setFont(font);
    }

    public void setClassName(String className) {
        this.name.setText(className);
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof AttributeLabel) {
            this.attributeFigure.add(figure);
        } else if (figure instanceof OperationLabel) {
            this.methodFigure.add(figure);
        } else {
            super.add(figure, constraint, index);
        }
    }

    public void moveAttribute(int index, boolean up) {
        List children = this.attributeFigure.getChildren();
        IFigure obj = (IFigure)children.get(index);
        this.attributeFigure.remove(obj);
        if (up) {
            this.attributeFigure.add(obj, index - 1);
        } else {
            this.attributeFigure.add(obj, index + 1);
        }
    }

    public void moveOperation(int index, boolean up) {
        List children = this.methodFigure.getChildren();
        IFigure obj = (IFigure)children.get(index);
        this.methodFigure.remove(obj);
        if (up) {
            this.methodFigure.add(obj, index - 1);
        } else {
            this.methodFigure.add(obj, index + 1);
        }
    }

    public void remove(IFigure figure) {
        if (figure instanceof AttributeLabel) {
            this.attributeFigure.remove(figure);
        } else if (figure instanceof OperationLabel) {
            this.methodFigure.remove(figure);
        } else {
            super.remove(figure);
        }
    }

    @Override
    public Label getLabel() {
        return this.name;
    }

    @Override
    public Rectangle getCellEditorRectangle() {
        Rectangle rect = this.name.getBounds().getCopy();
        if (this.name.getIcon() != null) {
            return new Rectangle(rect.x + 16, rect.y, rect.width - 16, rect.height);
        }
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void updatePresentation(AbstractUMLModel model) {
        if (model.isShowIcon()) {
            this.name.setIcon(this.icon);
        } else {
            this.name.setIcon(null);
        }
    }

    public void setStereoType(String stereoType) {
        if (stereoType == null || "".equals(stereoType)) {
            if (this.nameFigure.getChildren().contains(this.stereoType)) {
                this.nameFigure.remove((IFigure)this.stereoType);
            }
        } else {
            this.stereoType.setText("<<" + stereoType + ">>");
            if (!this.nameFigure.getChildren().contains(this.stereoType)) {
                this.nameFigure.add((IFigure)this.stereoType, 0);
            }
        }
    }
}

