/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.model;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.model.AttributeModel;
import net.java.amateras.uml.classdiagram.model.ListPropertyWrapper;
import net.java.amateras.uml.classdiagram.model.OperationModel;
import net.java.amateras.uml.classdiagram.model.StereoTypeModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.ICloneableModel;
import net.java.amateras.uml.model.TypeEntityModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class CommonEntityModel
extends AbstractUMLEntityModel
implements TypeEntityModel,
StereoTypeModel,
ICloneableModel {
    private static final long serialVersionUID = -5147978755371600265L;
    protected IPropertyDescriptor[] propertyDescriptors;
    private String stereoType = "";
    protected static final String P_ATTRIBUTES = "_attrs";
    protected static final String P_OPERATIONS = "_operations";
    private String name = "";

    public CommonEntityModel() {
        this.propertyDescriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"_stereo_type", UMLPlugin.getDefault().getResourceString("property.stereoType")), new PropertyDescriptor((Object)"_simpleEntityName", UMLPlugin.getDefault().getResourceString("property.simpleName")), new TextPropertyDescriptor((Object)"_entityName", UMLPlugin.getDefault().getResourceString("property.name")), new ColorPropertyDescriptor((Object)"_background", UMLPlugin.getDefault().getResourceString("property.background")), new PropertyDescriptor((Object)P_ATTRIBUTES, UMLPlugin.getDefault().getResourceString("property.attributes")), new PropertyDescriptor((Object)P_OPERATIONS, UMLPlugin.getDefault().getResourceString("property.operations"))};
    }

    public CommonEntityModel(CommonEntityModel toCopy) {
        this.setBackgroundColor(toCopy.getBackgroundColor().getRGB());
        this.setConstraint(new Rectangle(toCopy.getConstraint()));
        this.setForegroundColor(toCopy.getForegroundColor().getRGB());
        this.setName(toCopy.getName());
        this.setParent(toCopy.getParent());
        this.setShowIcon(toCopy.isShowIcon());
        this.setStereoType(toCopy.getStereoType());
        List<AbstractUMLModel> children = toCopy.getChildren();
        int i = 0;
        while (i < children.size()) {
            AbstractUMLModel child = children.get(i);
            if (child instanceof AttributeModel) {
                this.addChild((AttributeModel)((AttributeModel)child).clone());
            } else if (child instanceof OperationModel) {
                this.addChild((OperationModel)((OperationModel)child).clone());
            }
            ++i;
        }
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange("_entityName", oldName, newName);
    }

    @Override
    public void setSimpleName(String simpleName) {
        int lastDotPosition;
        String packageName = "";
        if (this.getName() != null && (lastDotPosition = this.getName().lastIndexOf(46)) != -1) {
            packageName = this.getName().substring(0, lastDotPosition);
        }
        if (packageName.length() > 0) {
            this.setName(String.valueOf(packageName) + "." + simpleName);
        } else {
            this.setName(simpleName);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals("_stereo_type")) {
            return this.getStereoType();
        }
        if (id.equals("_simpleEntityName")) {
            return this.getSimpleName();
        }
        if (id.equals("_entityName")) {
            return this.getName();
        }
        if (id.equals(P_ATTRIBUTES)) {
            ArrayList<AttributeModel> rv = new ArrayList<AttributeModel>();
            for (AbstractUMLModel element : this.getChildren()) {
                if (!(element instanceof AttributeModel)) continue;
                rv.add((AttributeModel)element);
            }
            return new ListPropertyWrapper(rv);
        }
        if (id.equals(P_OPERATIONS)) {
            ArrayList<OperationModel> rv = new ArrayList<OperationModel>();
            for (AbstractUMLModel element : this.getChildren()) {
                if (!(element instanceof OperationModel)) continue;
                rv.add((OperationModel)element);
            }
            return new ListPropertyWrapper(rv);
        }
        return super.getPropertyValue(id);
    }

    @Override
    public String getSimpleName() {
        int lastDotPosition;
        String simpleName = this.getName();
        if (this.getName() != null && (lastDotPosition = this.getName().lastIndexOf(46)) != -1) {
            simpleName = this.getName().substring(lastDotPosition + 1);
        }
        return simpleName;
    }

    @Override
    public boolean isPropertySet(Object id) {
        if (id.equals("_stereo_type")) {
            return true;
        }
        if (id.equals("_simpleEntityName")) {
            return true;
        }
        if (id.equals("_entityName")) {
            return true;
        }
        return super.isPropertySet(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals("_stereo_type")) {
            this.setStereoType((String)value);
        } else if (id.equals("_entityName")) {
            this.setName((String)value);
        }
        super.setPropertyValue(id, value);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getStereoType() {
        return this.stereoType == null ? "" : this.stereoType;
    }

    @Override
    public void setStereoType(String stereoType) {
        this.stereoType = stereoType;
        this.firePropertyChange("_stereo_type", null, stereoType);
    }

    @Override
    public Object clone() {
        throw new RuntimeException("Clone is not supported, use copy constructor instead");
    }
}

