/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.model;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.model.Argument;
import net.java.amateras.uml.classdiagram.model.ClassModel;
import net.java.amateras.uml.classdiagram.model.Visibility;
import net.java.amateras.uml.classdiagram.property.ArgumentsPropertyDescriptor;
import net.java.amateras.uml.classdiagram.property.EnumPropertyDescriptor;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.properties.BooleanPropertyDescriptor;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class OperationModel
extends AbstractUMLModel
implements Cloneable {
    private static final long serialVersionUID = 8136758854201705047L;
    private Visibility visibility = Visibility.PUBLIC;
    private String name = "";
    private String type = "void";
    private List<Argument> params = new ArrayList<Argument>();
    private boolean isAbstract = false;
    private boolean isStatic = false;
    public static final String P_VISIBILITY = "_visibility";
    public static final String P_NAME = "_name";
    public static final String P_TYPE = "_type";
    public static final String P_PARAMS = "_params";
    public static final String P_ABSTRACT = "_abstract";
    public static final String P_STATIC = "_static";

    public boolean isConstructor() {
        AbstractUMLEntityModel parent;
        if ((this.getType().length() == 0 || this.getType().equals("void")) && (parent = this.getParent()) != null && parent instanceof ClassModel) {
            String className = ((ClassModel)parent).getName();
            int index = className.lastIndexOf(46);
            if (index >= 0) {
                className = className.substring(index + 1);
            }
            return className.equals(this.getName());
        }
        return false;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        this.firePropertyChange(P_ABSTRACT, null, new Boolean(isAbstract));
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        this.firePropertyChange(P_STATIC, null, new Boolean(isStatic));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(P_NAME, null, name);
    }

    public List<Argument> getParams() {
        return this.params;
    }

    public void setParams(List<Argument> params) {
        this.params = params;
        this.firePropertyChange(P_PARAMS, null, params);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.firePropertyChange(P_TYPE, null, type);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
        this.firePropertyChange(P_VISIBILITY, null, visibility);
        if (this.getParent() != null) {
            this.getParent().forceUpdate();
        }
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_NAME, UMLPlugin.getDefault().getResourceString("property.name")), new TextPropertyDescriptor((Object)P_TYPE, UMLPlugin.getDefault().getResourceString("property.type")), new EnumPropertyDescriptor(P_VISIBILITY, UMLPlugin.getDefault().getResourceString("property.visibility"), Visibility.getVisibilities()), new ArgumentsPropertyDescriptor(P_PARAMS, UMLPlugin.getDefault().getResourceString("property.arguments")), new BooleanPropertyDescriptor(P_STATIC, UMLPlugin.getDefault().getResourceString("property.static")), new BooleanPropertyDescriptor(P_ABSTRACT, UMLPlugin.getDefault().getResourceString("property.abstract")), new ColorPropertyDescriptor((Object)"_foreground", UMLPlugin.getDefault().getResourceString("property.foreground"))};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(P_NAME)) {
            return this.getName();
        }
        if (id.equals(P_TYPE)) {
            return this.getType();
        }
        if (id.equals(P_VISIBILITY)) {
            return this.getVisibility();
        }
        if (id.equals(P_PARAMS)) {
            return this.getParams();
        }
        if (id.equals(P_STATIC)) {
            return new Boolean(this.isStatic());
        }
        if (id.equals(P_ABSTRACT)) {
            return new Boolean(this.isAbstract());
        }
        return super.getPropertyValue(id);
    }

    @Override
    public boolean isPropertySet(Object id) {
        if (id.equals(P_NAME)) {
            return true;
        }
        if (id.equals(P_TYPE)) {
            return true;
        }
        if (id.equals(P_VISIBILITY)) {
            return true;
        }
        if (id.equals(P_PARAMS)) {
            return true;
        }
        if (id.equals(P_STATIC)) {
            return true;
        }
        if (id.equals(P_ABSTRACT)) {
            return true;
        }
        return super.isPropertySet(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(P_NAME)) {
            this.setName((String)value);
        } else if (id.equals(P_TYPE)) {
            this.setType((String)value);
        } else if (id.equals(P_VISIBILITY)) {
            this.setVisibility((Visibility)value);
        } else if (id.equals(P_PARAMS)) {
            this.setParams((List)value);
        } else if (id.equals(P_STATIC)) {
            this.setStatic((Boolean)value);
        } else if (id.equals(P_ABSTRACT)) {
            this.setAbstract((Boolean)value);
        }
        super.setPropertyValue(id, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("(");
        int i = 0;
        while (i < this.params.size()) {
            if (i != 0) {
                sb.append(", ");
            }
            Argument arg = this.params.get(i);
            sb.append(arg.toString());
            ++i;
        }
        sb.append(")");
        if (!this.isConstructor()) {
            sb.append(": ");
            sb.append(this.getType());
        }
        return sb.toString();
    }

    public Object clone() {
        OperationModel newModel = new OperationModel();
        newModel.setName(this.getName());
        newModel.setType(this.getType());
        newModel.setVisibility(this.getVisibility());
        List<Argument> args = this.getParams();
        ArrayList<Argument> newArgs = new ArrayList<Argument>();
        int i = 0;
        while (i < args.size()) {
            newArgs.add((Argument)args.get(i).clone());
            ++i;
        }
        newModel.setParams(newArgs);
        newModel.setStatic(this.isStatic());
        newModel.setAbstract(this.isAbstract());
        return newModel;
    }
}

