/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.classdiagram.property;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.classdiagram.model.Argument;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ArgumentsEditDialog
extends Dialog {
    private Table table;
    private MenuItem add;
    private MenuItem edit;
    private MenuItem remove;
    private List<Argument> arguments;

    public ArgumentsEditDialog(Shell parent, List<Argument> arguments) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.arguments = arguments;
    }

    protected void constrainShellSize() {
        this.getShell().setSize(300, 200);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(UMLPlugin.getDefault().getResourceString("argumentsDialog.title"));
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.table = new Table(container, 67586);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.table, 16384);
        column1.setText(UMLPlugin.getDefault().getResourceString("argumentsDialog.label.argumentName"));
        column1.setWidth(120);
        TableColumn column2 = new TableColumn(this.table, 16384);
        column2.setText(UMLPlugin.getDefault().getResourceString("argumentsDialog.label.argumentType"));
        column2.setWidth(120);
        Menu menu = new Menu((Control)this.table);
        this.add = new MenuItem(menu, 8);
        this.add.setText(UMLPlugin.getDefault().getResourceString("argumentsDialog.menu.add"));
        this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ArgumentsEditDialog.this.addArgument();
            }
        });
        this.edit = new MenuItem(menu, 8);
        this.edit.setText(UMLPlugin.getDefault().getResourceString("argumentsDialog.menu.edit"));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ArgumentsEditDialog.this.editArgument();
            }
        });
        this.remove = new MenuItem(menu, 8);
        this.remove.setText(UMLPlugin.getDefault().getResourceString("argumentsDialog.menu.remove"));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ArgumentsEditDialog.this.removeArgument();
            }
        });
        this.table.setMenu(menu);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ArgumentsEditDialog.this.updateMenus();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ArgumentsEditDialog.this.editArgument();
            }
        });
        int i = 0;
        while (i < this.arguments.size()) {
            Argument arg = this.arguments.get(i);
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, arg.getName());
            item.setText(1, arg.getType());
            ++i;
        }
        return container;
    }

    private void updateMenus() {
        if (this.table.getSelectionCount() == 0) {
            this.edit.setEnabled(false);
            this.remove.setEnabled(false);
        } else {
            this.edit.setEnabled(true);
            this.remove.setEnabled(true);
        }
    }

    private void addArgument() {
        int count = this.table.getItems().length + 1;
        SingleArgumentDialog dialog = new SingleArgumentDialog(this.getShell(), "arg" + count, "int");
        if (dialog.open() == 0) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{dialog.getName(), dialog.getType()});
        }
    }

    private void editArgument() {
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            items[0].getText(0);
            SingleArgumentDialog dialog = new SingleArgumentDialog(this.getShell(), items[0].getText(0), items[0].getText(1));
            if (dialog.open() == 0) {
                items[0].setText(0, dialog.getName());
                items[0].setText(1, dialog.getType());
            }
        }
    }

    private void removeArgument() {
        TableItem[] items = this.table.getSelection();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    protected void okPressed() {
        this.arguments = new ArrayList<Argument>();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            Argument arg = new Argument();
            arg.setName(items[i].getText(0));
            arg.setType(items[i].getText(1));
            this.arguments.add(arg);
            ++i;
        }
        super.okPressed();
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    private class SingleArgumentDialog
    extends Dialog {
        private Text txtName;
        private Text txtType;
        private String name;
        private String type;

        public SingleArgumentDialog(Shell shell, String name, String type) {
            super(shell);
            this.name = "";
            this.type = "";
            this.name = name;
            this.type = type;
        }

        protected void constrainShellSize() {
            Shell shell = this.getShell();
            shell.pack();
            shell.setSize(300, shell.getSize().y);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(UMLPlugin.getDefault().getResourceString("argumentDialog.title"));
            Composite container = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            container.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            container.setLayout((Layout)layout);
            Label label = new Label(container, 0);
            label.setText(UMLPlugin.getDefault().getResourceString("argumentDialog.label.argumentName"));
            this.txtName = new Text(container, 2048);
            gd = new GridData(768);
            this.txtName.setLayoutData((Object)gd);
            this.txtName.setText(this.name);
            label = new Label(container, 0);
            label.setText(UMLPlugin.getDefault().getResourceString("argumentDialog.label.argumentType"));
            this.txtType = new Text(container, 2048);
            gd = new GridData(768);
            this.txtType.setLayoutData((Object)gd);
            this.txtType.setText(this.type);
            return container;
        }

        protected void okPressed() {
            this.name = this.txtName.getText();
            this.type = this.txtType.getText();
            super.okPressed();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

