/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.classdiagram.model.StereoTypeModel;
import net.java.amateras.uml.editpart.ConnectionBendpoint;
import net.java.amateras.uml.figure.PresentationFigure;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractUMLConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private StereoTypeDirectEditManager directManager;

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new StereoTypeDirectEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new UMLConnectionBendpointEditPolicy());
    }

    public void activate() {
        super.activate();
        ((AbstractUMLModel)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ((AbstractUMLModel)this.getModel()).removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void refreshBendpoints() {
        this.getConnectionFigure().setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        List<ConnectionBendpoint> bendpoints = ((AbstractUMLConnectionModel)this.getModel()).getBendpoints();
        ArrayList<RelativeBendpoint> constraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < bendpoints.size()) {
            ConnectionBendpoint wbp = bendpoints.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(wbp.getFirstRelativeDimension(), wbp.getSecondRelativeDimension());
            rbp.setWeight((float)(i + 1) / ((float)constraint.size() + 1.0f));
            constraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void refreshVisuals() {
        if (this.getFigure() instanceof PresentationFigure) {
            PresentationFigure figure = (PresentationFigure)this.getFigure();
            figure.updatePresentation((AbstractUMLModel)this.getModel());
        }
        this.refreshBendpoints();
        super.refreshVisuals();
    }

    protected Label getStereoTypeLabel() {
        return null;
    }

    public void performRequest(Request req) {
        if ((this.getStereoTypeLabel() != null || this.getModel() instanceof StereoTypeModel) && (req.getType().equals("direct edit") || req.getType().equals("open"))) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new StereoTypeDirectEditManager();
        }
        this.directManager.show();
    }

    private class BendpointCommand
    extends Command {
        protected int index = 0;
        protected Point location = null;
        protected AbstractUMLConnectionModel connectionModel = null;
        private Dimension d1 = null;
        private Dimension d2 = null;

        private BendpointCommand() {
        }

        protected Dimension getFirstRelativeDimension() {
            return this.d1;
        }

        protected Dimension getSecondRelativeDimension() {
            return this.d2;
        }

        protected int getIndex() {
            return this.index;
        }

        protected Point getLocation() {
            return this.location;
        }

        protected AbstractUMLConnectionModel getConnectionModel() {
            return this.connectionModel;
        }

        public void redo() {
            this.execute();
        }

        public void setRelativeDimensions(Dimension dim1, Dimension dim2) {
            this.d1 = dim1;
            this.d2 = dim2;
        }

        public void setIndex(int i) {
            this.index = i;
        }

        public void setLocation(Point p) {
            this.location = p;
        }

        public void setConnectionModel(AbstractUMLConnectionModel connection) {
            this.connectionModel = connection;
        }
    }

    private class CompositeCellEditorLocator
    implements CellEditorLocator {
        private CompositeCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = AbstractUMLConnectionEditPart.this.getStereoTypeLabel().getBounds().getCopy();
            AbstractUMLConnectionEditPart.this.figure.translateToAbsolute((Translatable)rect);
            if (rect.width == 0) {
                text.setBounds(rect.x - 20, rect.y, 40, rect.height);
            } else {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private class CreateBendpointCommand
    extends BendpointCommand {
        private CreateBendpointCommand() {
        }

        public void execute() {
            ConnectionBendpoint rbp = new ConnectionBendpoint(this.getFirstRelativeDimension(), this.getSecondRelativeDimension());
            this.getConnectionModel().addBendpoint(this.getIndex(), rbp);
            super.execute();
        }

        public void undo() {
            super.undo();
            this.getConnectionModel().removeBendpoint(this.getIndex());
        }
    }

    private class DeleteBendpointCommand
    extends BendpointCommand {
        private ConnectionBendpoint bendpoint = null;

        private DeleteBendpointCommand() {
        }

        public void execute() {
            this.bendpoint = this.getConnectionModel().getBendpoints().get(this.getIndex());
            this.getConnectionModel().removeBendpoint(this.getIndex());
            super.execute();
        }

        public void undo() {
            super.undo();
            this.getConnectionModel().addBendpoint(this.getIndex(), this.bendpoint);
        }
    }

    private class DeleteCommand
    extends Command {
        private AbstractUMLConnectionModel model;

        private DeleteCommand() {
        }

        public void setModel(AbstractUMLConnectionModel model) {
            this.model = model;
        }

        public void execute() {
            this.model.detachSource();
            this.model.detachTarget();
        }

        public void undo() {
            this.model.attachSource();
            this.model.attachTarget();
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldStereoType;
        private String newStereoType;

        private DirectEditCommand() {
        }

        public void execute() {
            StereoTypeModel model = (StereoTypeModel)AbstractUMLConnectionEditPart.this.getModel();
            this.oldStereoType = model.getStereoType();
            model.setStereoType(this.newStereoType);
        }

        public void setStereoType(String stereoType) {
            this.newStereoType = stereoType;
        }

        public void undo() {
            StereoTypeModel model = (StereoTypeModel)AbstractUMLConnectionEditPart.this.getModel();
            model.setStereoType(this.oldStereoType);
        }
    }

    private class EntityComponentEditPolicy
    extends ComponentEditPolicy {
        private EntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setModel((AbstractUMLConnectionModel)AbstractUMLConnectionEditPart.this.getModel());
            return command;
        }
    }

    private class MoveBendpointCommand
    extends BendpointCommand {
        private ConnectionBendpoint oldBendpoint = null;

        private MoveBendpointCommand() {
        }

        public void execute() {
            ConnectionBendpoint bp = new ConnectionBendpoint(this.getFirstRelativeDimension(), this.getSecondRelativeDimension());
            this.setOldBendpoint(this.getConnectionModel().getBendpoints().get(this.getIndex()));
            this.getConnectionModel().replaceBendpoint(this.getIndex(), bp);
            super.execute();
        }

        protected ConnectionBendpoint getOldBendpoint() {
            return this.oldBendpoint;
        }

        public void setOldBendpoint(ConnectionBendpoint bp) {
            this.oldBendpoint = bp;
        }

        public void undo() {
            super.undo();
            this.getConnectionModel().replaceBendpoint(this.getIndex(), this.getOldBendpoint());
        }
    }

    private class StereoTypeDirectEditManager
    extends DirectEditManager {
        public StereoTypeDirectEditManager() {
            super((GraphicalEditPart)AbstractUMLConnectionEditPart.this, TextCellEditor.class, (CellEditorLocator)new CompositeCellEditorLocator());
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((StereoTypeModel)AbstractUMLConnectionEditPart.this.getModel()).getStereoType());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class StereoTypeDirectEditPolicy
    extends DirectEditPolicy {
        private StereoTypeDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setStereoType((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }

    private class UMLConnectionBendpointEditPolicy
    extends BendpointEditPolicy {
        private UMLConnectionBendpointEditPolicy() {
        }

        protected Command getCreateBendpointCommand(BendpointRequest request) {
            CreateBendpointCommand command = new CreateBendpointCommand();
            Point p = request.getLocation();
            Connection conn = this.getConnection();
            conn.translateToRelative((Translatable)p);
            command.setLocation(p);
            Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
            Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)ref1);
            conn.translateToRelative((Translatable)ref2);
            command.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
            command.setConnectionModel((AbstractUMLConnectionModel)request.getSource().getModel());
            command.setIndex(request.getIndex());
            return command;
        }

        protected Command getDeleteBendpointCommand(BendpointRequest request) {
            DeleteBendpointCommand command = new DeleteBendpointCommand();
            Point p = request.getLocation();
            command.setLocation(p);
            command.setConnectionModel((AbstractUMLConnectionModel)request.getSource().getModel());
            command.setIndex(request.getIndex());
            return command;
        }

        protected Command getMoveBendpointCommand(BendpointRequest request) {
            MoveBendpointCommand command = new MoveBendpointCommand();
            Point p = request.getLocation();
            Connection conn = this.getConnection();
            conn.translateToRelative((Translatable)p);
            command.setLocation(p);
            Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
            Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)ref1);
            conn.translateToRelative((Translatable)ref2);
            command.setRelativeDimensions(p.getDifference(ref1), p.getDifference(ref2));
            command.setConnectionModel((AbstractUMLConnectionModel)request.getSource().getModel());
            command.setIndex(request.getIndex());
            return command;
        }
    }
}

