/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.editpart.ConnectionBendpoint;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.EntityModel;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractUMLEntityEditPart
extends AbstractUMLEditPart
implements NodeEditPart {
    private EntityDirectEditManager directManager = null;

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new EntityDirectEditPolicy());
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        Object model = this.getModel();
        if (model instanceof AbstractUMLEntityModel) {
            Rectangle constraint = ((AbstractUMLEntityModel)model).getConstraint();
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    protected List<AbstractUMLConnectionModel> getModelSourceConnections() {
        return ((AbstractUMLEntityModel)this.getModel()).getModelSourceConnections();
    }

    protected List<AbstractUMLConnectionModel> getModelTargetConnections() {
        return ((AbstractUMLEntityModel)this.getModel()).getModelTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_force_update")) {
            this.refreshChildren();
        }
        this.refreshVisuals();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public void performRequest(Request req) {
        if (this.getModel() instanceof EntityModel && (req.getType().equals("direct edit") || req.getType().equals("open"))) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new EntityDirectEditManager();
        }
        this.directManager.show();
    }

    private class CreateBendPointCommand
    extends Command {
        AbstractUMLConnectionModel model;
        private Rectangle bounds;

        private CreateBendPointCommand() {
        }

        public void setModel(AbstractUMLConnectionModel model) {
            this.model = model;
        }

        public void setSourceBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        public void execute() {
            super.execute();
            int width = this.bounds.width / 2 + 20;
            int height = -this.bounds.height / 2 - 20;
            ConnectionBendpoint bendpoint = new ConnectionBendpoint(new Dimension(0, 0), new Dimension(width, 0));
            this.model.addBendpoint(0, bendpoint);
            bendpoint = new ConnectionBendpoint(new Dimension(width, 0), new Dimension(width, height));
            this.model.addBendpoint(1, bendpoint);
            bendpoint = new ConnectionBendpoint(new Dimension(width, height), new Dimension(0, height));
            this.model.addBendpoint(2, bendpoint);
        }
    }

    private class CreateConnectionCommand
    extends Command {
        private AbstractUMLEntityModel source;
        private AbstractUMLEntityModel target;
        private AbstractUMLConnectionModel connection;

        private CreateConnectionCommand() {
        }

        public AbstractUMLConnectionModel getConnectionModel() {
            return this.connection;
        }

        public boolean canExecute() {
            return this.source != null && this.target != null;
        }

        public void execute() {
            this.connection.attachSource();
            this.connection.attachTarget();
        }

        public void setConnection(Object model) {
            this.connection = (AbstractUMLConnectionModel)model;
        }

        public void setSource(Object model) {
            this.source = (AbstractUMLEntityModel)model;
            this.connection.setSource(this.source);
        }

        public void setTarget(Object model) {
            this.target = (AbstractUMLEntityModel)model;
            this.connection.setTarget(this.target);
        }

        public void undo() {
            this.connection.detachSource();
            this.connection.detachTarget();
        }
    }

    public static class DeleteCommand
    extends Command {
        private AbstractUMLEntityModel container;
        private AbstractUMLModel model;
        private List<AbstractUMLConnectionModel> sourceConnections = new ArrayList<AbstractUMLConnectionModel>();
        private List<AbstractUMLConnectionModel> targetConnections = new ArrayList<AbstractUMLConnectionModel>();

        public void execute() {
            AbstractUMLConnectionModel model;
            this.sourceConnections.addAll(((AbstractUMLEntityModel)this.model).getModelSourceConnections());
            this.targetConnections.addAll(((AbstractUMLEntityModel)this.model).getModelTargetConnections());
            int i = 0;
            while (i < this.sourceConnections.size()) {
                model = this.sourceConnections.get(i);
                model.detachSource();
                model.detachTarget();
                ++i;
            }
            i = 0;
            while (i < this.targetConnections.size()) {
                model = this.targetConnections.get(i);
                model.detachSource();
                model.detachTarget();
                ++i;
            }
            this.container.removeChild(this.model);
        }

        public void setRootModel(Object root) {
            this.container = (AbstractUMLEntityModel)root;
        }

        public void setTargetModel(Object model) {
            this.model = (AbstractUMLModel)model;
        }

        public void undo() {
            AbstractUMLConnectionModel model;
            this.container.addChild(this.model);
            int i = 0;
            while (i < this.sourceConnections.size()) {
                model = this.sourceConnections.get(i);
                model.attachSource();
                model.attachTarget();
                ++i;
            }
            i = 0;
            while (i < this.targetConnections.size()) {
                model = this.targetConnections.get(i);
                model.attachSource();
                model.attachTarget();
                ++i;
            }
            this.sourceConnections.clear();
            this.targetConnections.clear();
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldName;
        private String newName;

        private DirectEditCommand() {
        }

        public void execute() {
            EntityModel model = (EntityModel)AbstractUMLEntityEditPart.this.getModel();
            this.oldName = model.getName();
            model.setName(this.newName);
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void undo() {
            EntityModel model = (EntityModel)AbstractUMLEntityEditPart.this.getModel();
            model.setName(this.oldName);
        }
    }

    private class EntityCellEditorLocator
    implements CellEditorLocator {
        private EntityCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            EntityFigure figure = (EntityFigure)AbstractUMLEntityEditPart.this.getFigure();
            Text text = (Text)celleditor.getControl();
            Rectangle rect = figure.getCellEditorRectangle();
            figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class EntityComponentEditPolicy
    extends ComponentEditPolicy {
        private EntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            DeleteCommand command = new DeleteCommand();
            command.setRootModel(this.getHost().getParent().getModel());
            command.setTargetModel(this.getHost().getModel());
            return command;
        }
    }

    private class EntityDirectEditManager
    extends DirectEditManager {
        public EntityDirectEditManager() {
            super((GraphicalEditPart)AbstractUMLEntityEditPart.this, TextCellEditor.class, (CellEditorLocator)new EntityCellEditorLocator());
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((EntityModel)AbstractUMLEntityEditPart.this.getModel()).getName());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class EntityDirectEditPolicy
    extends DirectEditPolicy {
        private EntityDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setName((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }

    private class EntityLayoutEditPolicy
    extends LayoutEditPolicy {
        private EntityLayoutEditPolicy() {
        }

        protected Command getMoveChildrenCommand(Request request) {
            return null;
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            return new NonResizableEditPolicy();
        }

        protected Command getCreateCommand(CreateRequest request) {
            return null;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }

    private class NodeEditPolicy
    extends GraphicalNodeEditPolicy {
        private NodeEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            AbstractUMLConnectionModel conn = ((CreateConnectionCommand)request.getStartCommand()).getConnectionModel();
            AbstractUMLEntityModel model = (AbstractUMLEntityModel)this.getHost().getModel();
            CreateConnectionCommand command = (CreateConnectionCommand)request.getStartCommand();
            command.setTarget(model);
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.add((Command)command);
            if (conn.getSource().equals(model)) {
                IFigure hostFigure = this.getHostFigure();
                Rectangle bounds = hostFigure.getBounds();
                CreateBendPointCommand pointCommand = new CreateBendPointCommand();
                pointCommand.setModel(conn);
                pointCommand.setSourceBounds(bounds);
                compoundCommand.add((Command)pointCommand);
            }
            return compoundCommand.unwrap();
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel)request.getNewObject();
            AbstractUMLEntityModel model = (AbstractUMLEntityModel)this.getHost().getModel();
            CreateConnectionCommand command = new CreateConnectionCommand();
            command.setConnection(conn);
            command.setSource(model);
            request.setStartCommand((Command)command);
            return command;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel)request.getConnectionEditPart().getModel();
            AbstractUMLEntityModel model = (AbstractUMLEntityModel)this.getHost().getModel();
            ReconnectTargetCommand command = new ReconnectTargetCommand();
            command.setConnection(conn);
            command.setTarget(model);
            return command;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            AbstractUMLConnectionModel conn = (AbstractUMLConnectionModel)request.getConnectionEditPart().getModel();
            AbstractUMLEntityModel model = (AbstractUMLEntityModel)this.getHost().getModel();
            ReconnectSourceCommand command = new ReconnectSourceCommand();
            command.setConnection(conn);
            command.setSource(model);
            return command;
        }
    }

    private class ReconnectSourceCommand
    extends Command {
        private AbstractUMLEntityModel source;
        private AbstractUMLEntityModel oldSource;
        private AbstractUMLConnectionModel connection;
        private List<ConnectionBendpoint> oldBendpoints;

        private ReconnectSourceCommand() {
        }

        public void execute() {
            this.oldBendpoints = new ArrayList<ConnectionBendpoint>(this.connection.getBendpoints());
            this.connection.detachSource();
            this.connection.setSource(this.source);
            this.connection.attachSource();
            for (ConnectionBendpoint point : this.oldBendpoints) {
                this.connection.removeBendpoint(point);
            }
        }

        public void setConnection(Object model) {
            this.connection = (AbstractUMLConnectionModel)model;
            this.oldSource = this.connection.getSource();
        }

        public void setSource(Object model) {
            this.source = (AbstractUMLEntityModel)model;
        }

        public boolean canExecute() {
            if (this.connection.getTarget() == null || this.source == null) {
                return false;
            }
            return !this.connection.getTarget().equals(this.source);
        }

        public void undo() {
            this.connection.detachSource();
            this.connection.setSource(this.oldSource);
            this.connection.attachSource();
            int i = 0;
            while (i < this.oldBendpoints.size()) {
                this.connection.addBendpoint(i, this.oldBendpoints.get(i));
                ++i;
            }
        }
    }

    private class ReconnectTargetCommand
    extends Command {
        private AbstractUMLEntityModel target;
        private AbstractUMLEntityModel oldTarget;
        private AbstractUMLConnectionModel connection;
        private List<ConnectionBendpoint> oldBendpoints;

        private ReconnectTargetCommand() {
        }

        public void execute() {
            this.oldBendpoints = new ArrayList<ConnectionBendpoint>(this.connection.getBendpoints());
            this.connection.detachTarget();
            this.connection.setTarget(this.target);
            this.connection.attachTarget();
            for (ConnectionBendpoint point : this.oldBendpoints) {
                this.connection.removeBendpoint(point);
            }
        }

        public void setConnection(Object model) {
            this.connection = (AbstractUMLConnectionModel)model;
            this.oldTarget = this.connection.getTarget();
        }

        public void setTarget(Object model) {
            this.target = (AbstractUMLEntityModel)model;
        }

        public boolean canExecute() {
            if (this.connection.getSource() == null || this.target == null) {
                return false;
            }
            return !this.connection.getSource().equals(this.target);
        }

        public void undo() {
            this.connection.detachTarget();
            this.connection.setTarget(this.oldTarget);
            this.connection.attachTarget();
            int i = 0;
            while (i < this.oldBendpoints.size()) {
                this.connection.addBendpoint(i, this.oldBendpoints.get(i));
                ++i;
            }
        }
    }
}

