/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.editpart;

import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.editpart.MultiLineCellEditor;
import net.java.amateras.uml.figure.NoteFigure;
import net.java.amateras.uml.model.NoteModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

public class NoteEditPart
extends AbstractUMLEntityEditPart {
    private DirectEditManager directManager;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new NoteDirectEditPolicy());
    }

    protected IFigure createFigure() {
        NoteFigure figure = new NoteFigure();
        return figure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        ((NoteFigure)this.figure).setText(((NoteModel)this.getModel()).getContent());
    }

    @Override
    public void performRequest(Request req) {
        if (req.getType().equals("direct edit") || req.getType().equals("open")) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new NoteDirectEditManager();
        }
        this.directManager.show();
    }

    private class DirectEditCommand
    extends Command {
        private String oldName;
        private String newName;

        private DirectEditCommand() {
        }

        public void execute() {
            NoteModel model = (NoteModel)NoteEditPart.this.getModel();
            this.oldName = model.getContent();
            model.setContent(this.newName);
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void undo() {
            NoteModel model = (NoteModel)NoteEditPart.this.getModel();
            model.setContent(this.oldName);
        }
    }

    private class NoteCellEditorLocator
    implements CellEditorLocator {
        private NoteCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            IFigure figure = NoteEditPart.this.getFigure();
            Text text = (Text)celleditor.getControl();
            Rectangle rect = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x + 5, rect.y + 5, rect.width - 5, rect.height - 5);
        }
    }

    private class NoteDirectEditManager
    extends DirectEditManager {
        public NoteDirectEditManager() {
            super((GraphicalEditPart)NoteEditPart.this, MultiLineCellEditor.class, (CellEditorLocator)new NoteCellEditorLocator());
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((NoteModel)NoteEditPart.this.getModel()).getContent());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class NoteDirectEditPolicy
    extends DirectEditPolicy {
        private NoteDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setName((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

