/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.model.RootModel;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class RootEditPart
extends AbstractUMLEditPart {
    private Set<Class<NoteModel>> RESIZABLE = new HashSet<Class<NoteModel>>();

    public RootEditPart() {
        this.RESIZABLE.add(NoteModel.class);
    }

    protected void addResizableClass(Class c) {
        this.RESIZABLE.add(c);
    }

    protected IFigure createFigure() {
        Layer figure = new Layer(){

            public void paint(Graphics graphics) {
                if (UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.antialias")) {
                    graphics.setAntialias(1);
                    graphics.setTextAntialias(1);
                }
                super.paint(graphics);
            }
        };
        figure.setLayoutManager((LayoutManager)new XYLayout());
        ConnectionLayer layer = (ConnectionLayer)this.getLayer("Connection Layer");
        layer.setConnectionRouter(ConnectionRouter.NULL);
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RootEditPolicy());
    }

    protected List<?> getModelChildren() {
        return ((RootModel)this.getModel()).getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_children")) {
            this.refreshChildren();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return (SnapToHelper)snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    private class ChangeConstraintCommand
    extends Command {
        private AbstractUMLEntityModel model;
        private Rectangle constraint;
        private Rectangle oldConstraint;

        private ChangeConstraintCommand() {
        }

        public void execute() {
            this.model.setConstraint(this.constraint);
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public void setModel(AbstractUMLEntityModel model) {
            this.model = model;
            this.oldConstraint = model.getConstraint();
        }

        public void undo() {
            this.model.setConstraint(this.oldConstraint);
        }
    }

    private class CreateAddCommand
    extends Command {
        private RootModel target;
        private AbstractUMLEntityModel model;
        private AbstractUMLEntityModel container;

        private CreateAddCommand() {
        }

        public void execute() {
            this.container = this.model.getParent();
            this.container.removeChild(this.model);
            this.target.addChild(this.model);
        }

        public void undo() {
            this.target.removeChild(this.model);
            this.container.addChild(this.model);
        }

        public void setTarget(RootModel target) {
            this.target = target;
        }

        public void setModel(AbstractUMLEntityModel model) {
            this.model = model;
        }
    }

    private class CreateCommand
    extends Command {
        private RootModel root;
        private AbstractUMLEntityModel model;

        private CreateCommand() {
        }

        public void execute() {
            this.root.copyFilter(this.model);
            this.root.copyPresentation(this.model);
            this.root.addChild(this.model);
        }

        public void setRootModel(Object root) {
            this.root = (RootModel)root;
        }

        public void setModel(Object model) {
            this.model = (AbstractUMLEntityModel)model;
        }

        public void undo() {
            this.root.removeChild(this.model);
        }
    }

    private class RootEditPolicy
    extends XYLayoutEditPolicy {
        private RootEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            if (RootEditPart.this.RESIZABLE.contains(child.getModel().getClass())) {
                return new ResizableEditPolicy();
            }
            return new NonResizableEditPolicy();
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            if (!(child.getModel() instanceof AbstractUMLEntityModel)) {
                return null;
            }
            CreateAddCommand command = new CreateAddCommand();
            command.setModel((AbstractUMLEntityModel)child.getModel());
            command.setTarget((RootModel)this.getHost().getModel());
            ChangeConstraintCommand nextCommand = new ChangeConstraintCommand();
            nextCommand.setModel((AbstractUMLEntityModel)child.getModel());
            nextCommand.setConstraint((Rectangle)constraint);
            return command.chain(nextCommand);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            command.setModel((AbstractUMLEntityModel)child.getModel());
            command.setConstraint((Rectangle)constraint);
            return command;
        }

        protected Command getCreateCommand(CreateRequest request) {
            CreateCommand command = new CreateCommand();
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            AbstractUMLEntityModel model = (AbstractUMLEntityModel)request.getNewObject();
            if (!RootEditPart.this.RESIZABLE.contains(model.getClass())) {
                constraint.width = -1;
                constraint.height = -1;
            }
            model.setConstraint(constraint);
            command.setRootModel(this.getHost().getModel());
            command.setModel(model);
            return command;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }
}

