/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.figure;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class CustomBorderLayout
extends BorderLayout {
    public static final Integer CENTER = new Integer(2);
    public static final Integer TOP = new Integer(8);
    public static final Integer BOTTOM = new Integer(32);
    public static final Integer LEFT = new Integer(1);
    public static final Integer RIGHT = new Integer(4);
    private IFigure center;
    private IFigure left;
    private IFigure top;
    private IFigure bottom;
    private IFigure right;
    private int vGap = 0;
    private int hGap = 0;
    private boolean stretchCenterWidth = true;
    private boolean stretchCenterHeight = false;

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Dimension childSize;
        int minWHint = 0;
        int minHHint = 0;
        if (wHint < 0) {
            minWHint = -1;
        }
        if (hHint < 0) {
            minHHint = -1;
        }
        Insets border = container.getInsets();
        wHint = Math.max(minWHint, wHint - border.getWidth());
        hHint = Math.max(minHHint, hHint - border.getHeight());
        Dimension minSize = new Dimension();
        int middleRowWidth = 0;
        int middleRowHeight = 0;
        int rows = 0;
        int columns = 0;
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getMinimumSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            minSize.setSize(childSize);
            ++rows;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getMinimumSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            minSize.width = Math.max(minSize.width, childSize.width);
            minSize.height += childSize.height;
            ++rows;
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getMinimumSize(wHint, hHint);
            middleRowWidth = childSize.width;
            middleRowHeight = childSize.height;
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getMinimumSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.center != null && this.center.isVisible()) {
            childSize = this.center.getMinimumSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            ++columns;
        }
        minSize.height += middleRowHeight + border.getHeight() + ((rows += columns > 0 ? 1 : 0) - 1) * this.vGap;
        minSize.width = Math.max(minSize.width, middleRowWidth) + border.getWidth() + (columns - 1) * this.hGap;
        return minSize;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension childSize;
        int minWHint = 0;
        int minHHint = 0;
        if (wHint < 0) {
            minWHint = -1;
        }
        if (hHint < 0) {
            minHHint = -1;
        }
        Insets border = container.getInsets();
        wHint = Math.max(minWHint, wHint - border.getWidth());
        hHint = Math.max(minHHint, hHint - border.getHeight());
        Dimension prefSize = new Dimension();
        int middleRowWidth = 0;
        int middleRowHeight = 0;
        int rows = 0;
        int columns = 0;
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getPreferredSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            prefSize.setSize(childSize);
            ++rows;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getPreferredSize(wHint, hHint);
            hHint = Math.max(minHHint, hHint - (childSize.height + this.vGap));
            prefSize.width = Math.max(prefSize.width, childSize.width);
            prefSize.height += childSize.height;
            ++rows;
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getPreferredSize(wHint, hHint);
            middleRowWidth = childSize.width;
            middleRowHeight = childSize.height;
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getPreferredSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            wHint = Math.max(minWHint, wHint - (childSize.width + this.hGap));
            ++columns;
        }
        if (this.center != null && this.center.isVisible()) {
            childSize = this.center.getPreferredSize(wHint, hHint);
            middleRowWidth += childSize.width;
            middleRowHeight = Math.max(childSize.height, middleRowHeight);
            ++columns;
        }
        prefSize.height += middleRowHeight + border.getHeight() + ((rows += columns > 0 ? 1 : 0) - 1) * this.vGap;
        prefSize.width = Math.max(prefSize.width, middleRowWidth) + border.getWidth() + (columns - 1) * this.hGap;
        return prefSize;
    }

    public void layout(IFigure container) {
        Dimension childSize;
        Rectangle area = container.getClientArea();
        Rectangle rect = new Rectangle();
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getPreferredSize(area.width, -1);
            rect.setLocation(area.x, area.y);
            rect.setSize(childSize);
            rect.width = area.width;
            this.top.setBounds(rect);
            area.y += rect.height + this.vGap;
            area.height -= rect.height + this.vGap;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getPreferredSize(Math.max(area.width, 0), -1);
            rect.setSize(childSize);
            rect.width = area.width;
            rect.setLocation(area.x, area.y + area.height - rect.height);
            this.bottom.setBounds(rect);
            area.height -= rect.height + this.vGap;
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getPreferredSize(-1, Math.max(0, area.height));
            rect.setLocation(area.x, area.y);
            rect.width = childSize.width;
            rect.height = Math.max(0, area.height);
            this.left.setBounds(rect);
            area.x += rect.width + this.hGap;
            area.width -= rect.width + this.hGap;
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getPreferredSize(-1, Math.max(0, area.height));
            rect.width = childSize.width;
            rect.height = Math.max(0, area.height);
            rect.setLocation(area.x + area.width - rect.width, area.y);
            this.right.setBounds(rect);
            area.width -= rect.width + this.hGap;
        }
        if (this.center != null && this.center.isVisible()) {
            childSize = this.center.getPreferredSize(Math.max(0, area.width), Math.max(0, area.height));
            if (!this.stretchCenterHeight && childSize.height < area.height) {
                area.y += (area.height - childSize.height) / 2;
                area.height = childSize.height;
            }
            if (!this.stretchCenterWidth && childSize.width < area.width) {
                area.x += (area.width - childSize.width) / 2;
                area.width = childSize.width;
            }
            this.center.setBounds(area);
        }
    }

    public void remove(IFigure child) {
        if (this.center == child) {
            this.center = null;
        } else if (this.top == child) {
            this.top = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        } else if (this.right == child) {
            this.right = null;
        } else if (this.left == child) {
            this.left = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.remove(child);
        super.setConstraint(child, constraint);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 8: {
                this.top = child;
                break;
            }
            case 32: {
                this.bottom = child;
                break;
            }
            case 4: {
                this.right = child;
                break;
            }
            case 1: {
                this.left = child;
                break;
            }
        }
    }

    public void setHorizontalSpacing(int gap) {
        this.hGap = gap;
    }

    public void setVerticalSpacing(int gap) {
        this.vGap = gap;
    }

    public boolean isStretchCenterHeight() {
        return this.stretchCenterHeight;
    }

    public void setStretchCenterHeight(boolean stretchCenterHeight) {
        this.stretchCenterHeight = stretchCenterHeight;
    }

    public boolean isStretchCenterWidth() {
        return this.stretchCenterWidth;
    }

    public void setStretchCenterWidth(boolean stretchCenterWidth) {
        this.stretchCenterWidth = stretchCenterWidth;
    }
}

