/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.figure;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;

public class NoteFigure
extends Figure {
    TextFlow nameFlow;

    public NoteFigure() {
        this.setBorder((Border)new CompoundBorder((Border)new LineBorder(){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                tempRect.setBounds(1.getPaintRectangle((IFigure)figure, (Insets)insets));
                if (this.getWidth() % 2 == 1) {
                    --1.tempRect.width;
                    --1.tempRect.height;
                }
                tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                graphics.setLineWidth(this.getWidth());
                if (this.getColor() != null) {
                    graphics.setForegroundColor(this.getColor());
                }
                PointList list = new PointList();
                list.addPoint(1.tempRect.x, 1.tempRect.y);
                list.addPoint(1.tempRect.x + 1.tempRect.width - 2, 1.tempRect.y);
                list.addPoint(1.tempRect.x + 1.tempRect.width - 2, 1.tempRect.y + 1.tempRect.height - 12);
                list.addPoint(1.tempRect.x + 1.tempRect.width - 12, 1.tempRect.y + 1.tempRect.height - 2);
                list.addPoint(1.tempRect.x, 1.tempRect.y + 1.tempRect.height - 2);
                graphics.drawPolygon(list);
            }
        }, (Border)new MarginBorder(3)));
        ToolbarLayout layout = new ToolbarLayout();
        this.setLayoutManager((LayoutManager)layout);
        FlowPage page = new FlowPage();
        page.setForegroundColor(ColorConstants.black);
        this.setBackgroundColor(ColorConstants.white);
        BlockFlow block = new BlockFlow();
        this.nameFlow = new TextFlow();
        this.nameFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.nameFlow, 1));
        block.add((IFigure)this.nameFlow);
        page.add((IFigure)block);
        this.setOpaque(true);
        this.add((IFigure)page);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle tempRect = this.getBounds().getCopy();
        PointList list = new PointList();
        graphics.setBackgroundColor(ColorConstants.gray);
        list.addPoint(tempRect.x, tempRect.y);
        list.addPoint(tempRect.x + tempRect.width, tempRect.y + 2);
        list.addPoint(tempRect.x + tempRect.width, tempRect.y + tempRect.height - 12);
        list.addPoint(tempRect.x + tempRect.width - 12, tempRect.y + tempRect.height);
        list.addPoint(tempRect.x + 2, tempRect.y + tempRect.height);
        graphics.fillPolygon(list);
        list.removeAllPoints();
        list.addPoint(tempRect.x, tempRect.y);
        list.addPoint(tempRect.x + tempRect.width - 3, tempRect.y);
        list.addPoint(tempRect.x + tempRect.width - 3, tempRect.y + tempRect.height - 13);
        list.addPoint(tempRect.x + tempRect.width - 13, tempRect.y + tempRect.height - 3);
        list.addPoint(tempRect.x, tempRect.y + tempRect.height - 3);
        graphics.setBackgroundColor(ColorConstants.white);
        graphics.fillPolygon(list);
    }

    public void setText(String text) {
        this.nameFlow.setText(text);
    }
}

