/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractUMLEntityModel
extends AbstractUMLModel {
    private static final long serialVersionUID = -8875966173249745953L;
    private Rectangle constraint;
    private List<AbstractUMLConnectionModel> sourceConnections = new ArrayList<AbstractUMLConnectionModel>();
    private List<AbstractUMLConnectionModel> targetConnections = new ArrayList<AbstractUMLConnectionModel>();
    private List<AbstractUMLModel> children = new ArrayList<AbstractUMLModel>();
    private Map<String, Boolean> filterProperty = new HashMap<String, Boolean>();
    public static final String P_CONSTRAINT = "_constraint";
    public static final String P_SOURCE_CONNECTION = "_source_connection";
    public static final String P_TARGET_CONNECTION = "_target_connection";
    public static final String P_CHILDREN = "_children";
    public static final String P_FILTER = "_filter";
    public static final String P_FORCE_UPDATE = "_force_update";

    public Map<String, Boolean> getFilterProperty() {
        return this.filterProperty;
    }

    public void setFilterProperty(Map<String, Boolean> filterProperty) {
        this.filterProperty = filterProperty;
        this.firePropertyChange(P_FILTER, null, filterProperty);
    }

    public Rectangle getConstraint() {
        return this.constraint;
    }

    public void addChild(AbstractUMLModel model) {
        this.children.add(model);
        model.setParent(this);
        this.firePropertyChange(P_CHILDREN, null, model);
    }

    public void removeChild(AbstractUMLModel model) {
        this.children.remove(model);
        model.setParent(this);
        this.firePropertyChange(P_CHILDREN, null, model);
    }

    public void forceUpdate() {
        this.firePropertyChange(P_FORCE_UPDATE, null, null);
    }

    public List<AbstractUMLModel> getChildren() {
        return this.children;
    }

    public void setConstraint(Rectangle constraint) {
        if (constraint.x < 0) {
            constraint.x = 0;
        }
        if (constraint.y < 0) {
            constraint.y = 0;
        }
        this.constraint = constraint;
        this.firePropertyChange(P_CONSTRAINT, null, constraint);
    }

    public void addSourceConnection(AbstractUMLConnectionModel connx) {
        this.sourceConnections.add(connx);
        this.firePropertyChange(P_SOURCE_CONNECTION, null, connx);
    }

    public void addTargetConnection(AbstractUMLConnectionModel connx) {
        this.targetConnections.add(connx);
        this.firePropertyChange(P_TARGET_CONNECTION, null, connx);
    }

    public List<AbstractUMLConnectionModel> getModelSourceConnections() {
        return this.sourceConnections;
    }

    public List<AbstractUMLConnectionModel> getModelTargetConnections() {
        return this.targetConnections;
    }

    public void removeSourceConnection(AbstractUMLConnectionModel connx) {
        this.sourceConnections.remove(connx);
        this.firePropertyChange(P_SOURCE_CONNECTION, connx, null);
    }

    public void removeTargetConnection(AbstractUMLConnectionModel connx) {
        this.targetConnections.remove(connx);
        this.firePropertyChange(P_TARGET_CONNECTION, connx, null);
    }

    @Override
    public void setBackgroundColor(RGB backgroundColor) {
        for (AbstractUMLModel element : this.children) {
            element.setBackgroundColor(backgroundColor);
        }
        super.setBackgroundColor(backgroundColor);
    }

    @Override
    public void setForegroundColor(RGB foregroundColor) {
        for (AbstractUMLModel element : this.children) {
            element.setForegroundColor(foregroundColor);
        }
        super.setForegroundColor(foregroundColor);
    }

    @Override
    public void setShowIcon(boolean showIcon) {
        for (AbstractUMLModel element : this.children) {
            element.setShowIcon(showIcon);
        }
        super.setShowIcon(showIcon);
    }
}

