/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import net.java.amateras.uml.UMLColorRegistry;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.properties.BooleanPropertyDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractUMLModel
implements Serializable,
IPropertySource {
    private static final long serialVersionUID = 79681161290534534L;
    public static final String P_BACKGROUND_COLOR = "_background";
    public static final String P_FOREGROUND_COLOR = "_foreground";
    public static final String P_SHOW_ICON = "_showicon";
    private RGB backgroundColor;
    private RGB foregroundColor;
    private boolean showIcon = true;
    private AbstractUMLEntityModel parent;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.listeners.firePropertyChange(propName, oldValue, newValue);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public Object getEditableValue() {
        return this;
    }

    public void setParent(AbstractUMLEntityModel parent) {
        this.parent = parent;
    }

    public AbstractUMLEntityModel getParent() {
        return this.parent;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new ColorPropertyDescriptor((Object)P_BACKGROUND_COLOR, UMLPlugin.getDefault().getResourceString("property.background")), new ColorPropertyDescriptor((Object)P_FOREGROUND_COLOR, UMLPlugin.getDefault().getResourceString("property.foreground")), new BooleanPropertyDescriptor(P_SHOW_ICON, UMLPlugin.getDefault().getResourceString("property.showicon"))};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(P_BACKGROUND_COLOR)) {
            return this.backgroundColor;
        }
        if (P_FOREGROUND_COLOR.equals(id)) {
            return this.foregroundColor;
        }
        if (P_SHOW_ICON.equals(id)) {
            return new Boolean(this.isShowIcon());
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return P_BACKGROUND_COLOR.equals(id) || P_FOREGROUND_COLOR.equals(id) || P_SHOW_ICON.equals(id);
    }

    public void setPropertyValue(Object id, Object value) {
        if (P_BACKGROUND_COLOR.equals(id)) {
            this.setBackgroundColor((RGB)value);
        } else if (P_FOREGROUND_COLOR.equals(id)) {
            this.setForegroundColor((RGB)value);
        } else if (P_SHOW_ICON.equals(id)) {
            this.setShowIcon((Boolean)value);
        }
    }

    public void resetPropertyValue(Object id) {
    }

    public Color getBackgroundColor() {
        return UMLColorRegistry.getColor(this.backgroundColor);
    }

    public void setBackgroundColor(RGB backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.firePropertyChange(P_BACKGROUND_COLOR, null, backgroundColor);
    }

    public Color getForegroundColor() {
        return UMLColorRegistry.getColor(this.foregroundColor);
    }

    public void setForegroundColor(RGB foregroundColor) {
        this.foregroundColor = foregroundColor;
        this.firePropertyChange(P_FOREGROUND_COLOR, null, foregroundColor);
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
        this.firePropertyChange(P_SHOW_ICON, null, new Boolean(showIcon));
    }

    public void copyPresentation(AbstractUMLModel model) {
        if (this.backgroundColor != null) {
            model.setBackgroundColor(this.backgroundColor);
        }
        if (this.foregroundColor != null) {
            model.setForegroundColor(this.foregroundColor);
        }
        model.setShowIcon(this.showIcon);
    }
}

