/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram;

import net.java.amateras.uml.DiagramEditor;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.model.RootModel;
import net.java.amateras.uml.sequencediagram.action.AddReturnMessageAction;
import net.java.amateras.uml.sequencediagram.action.ImportClassModelAction;
import net.java.amateras.uml.sequencediagram.editpart.SequenceEditPartFactory;
import net.java.amateras.uml.sequencediagram.figure.InstanceFigure;
import net.java.amateras.uml.sequencediagram.model.ActorModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class SequenceDiagramEditor
extends DiagramEditor {
    private AddReturnMessageAction returnMessageAction;
    private ImportClassModelAction importClassModelAction;

    protected PaletteRoot getPaletteRoot() {
        PaletteRoot root = new PaletteRoot();
        UMLPlugin plugin = UMLPlugin.getDefault();
        PaletteGroup tools = new PaletteGroup(plugin.getResourceString("palette.tool"));
        SelectionToolEntry tool = new SelectionToolEntry();
        tools.add((PaletteEntry)tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tools.add((PaletteEntry)tool);
        PaletteDrawer common = new PaletteDrawer(plugin.getResourceString("palette.common"));
        common.add(this.createEntityEntry(plugin.getResourceString("palette.common.note"), NoteModel.class, "icons/note.gif"));
        PaletteDrawer entities = new PaletteDrawer(plugin.getResourceString("palette.entity"));
        entities.add(this.createEntityEntry(plugin.getResourceString("palette.entity.instance"), InstanceModel.class, "icons/class.gif"));
        entities.add(this.createEntityEntry(plugin.getResourceString("palette.entity.actor"), ActorModel.class, "icons/actor16.gif"));
        PaletteDrawer relations = new PaletteDrawer(plugin.getResourceString("palette.message"));
        relations.add(this.createConnectionEntry(plugin.getResourceString("palette.message"), SyncMessageModel.class, "icons/dependency.gif"));
        root.add((PaletteEntry)tools);
        root.add((PaletteEntry)common);
        root.add((PaletteEntry)entities);
        root.add((PaletteEntry)relations);
        return root;
    }

    @Override
    protected RootModel createInitializeModel() {
        InteractionModel model = new InteractionModel();
        model.setBackgroundColor(InstanceFigure.INSTANCE_COLOR.getRGB());
        model.setForegroundColor(ColorConstants.black.getRGB());
        model.setShowIcon(true);
        return model;
    }

    @Override
    protected String getDiagramType() {
        return "sequence";
    }

    @Override
    protected void createDiagramAction(GraphicalViewer viewer) {
        this.returnMessageAction = new AddReturnMessageAction(this.getCommandStack(), viewer);
        this.importClassModelAction = new ImportClassModelAction(this.getCommandStack(), viewer);
    }

    @Override
    protected void fillDiagramPopupMenu(MenuManager manager) {
        manager.add((IContributionItem)new Separator("generate"));
        manager.add((IAction)this.returnMessageAction);
        manager.add((IAction)this.importClassModelAction);
    }

    @Override
    protected void updateDiagramAction(ISelection selection) {
        this.returnMessageAction.update((IStructuredSelection)selection);
        this.importClassModelAction.update((IStructuredSelection)selection);
    }

    @Override
    protected EditPartFactory createEditPartFactory() {
        return new SequenceEditPartFactory();
    }
}

