/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.action;

import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.action.AbstractUMLEditorAction;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.sequencediagram.editpart.ActivationEditPart;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.ReturnMessageModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AddReturnMessageAction
extends AbstractUMLEditorAction {
    private CommandStack stack;
    private ActivationModel target;
    private ActivationModel source;

    public AddReturnMessageAction(CommandStack stack, GraphicalViewer viewer) {
        super(UMLPlugin.getDefault().getResourceString("menu.addReturnMessage"), viewer);
        this.stack = stack;
    }

    @Override
    public void update(IStructuredSelection sel) {
        Object element = sel.getFirstElement();
        if (element instanceof ActivationEditPart) {
            ActivationEditPart editPart = (ActivationEditPart)element;
            this.target = this.getSourceActivation((ActivationModel)editPart.getModel());
            this.source = (ActivationModel)editPart.getModel();
        } else {
            this.source = null;
            this.target = null;
        }
        this.setEnabled(this.source != null && this.target != null);
    }

    public void run() {
        this.stack.execute((Command)new CreateReturnMessageCommand(this.target, this.source));
    }

    private ActivationModel getSourceActivation(ActivationModel model) {
        List<AbstractUMLConnectionModel> connections = model.getModelSourceConnections();
        for (AbstractUMLConnectionModel element : connections) {
            if (!(element instanceof ReturnMessageModel)) continue;
            return null;
        }
        List<SyncMessageModel> connection = model.getSyncTargetConnection();
        for (SyncMessageModel messageModel : connection) {
            if (messageModel.isRecursive()) continue;
            return (ActivationModel)messageModel.getSource();
        }
        return null;
    }

    private static class CreateReturnMessageCommand
    extends Command {
        private ReturnMessageModel msg;
        private ActivationModel target;
        private ActivationModel source;

        public CreateReturnMessageCommand(ActivationModel target, ActivationModel source) {
            this.target = target;
            this.source = source;
        }

        public void execute() {
            this.msg = new ReturnMessageModel();
            this.msg.setSource(this.source);
            this.msg.setTarget(this.target);
            this.msg.attachSource();
            this.msg.attachTarget();
        }

        public void undo() {
            this.msg.detachSource();
            this.msg.detachTarget();
        }
    }
}

