/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.sequencediagram.editpart.ConnectionCommand;
import net.java.amateras.uml.sequencediagram.editpart.IncomingFeedbackAnchor;
import net.java.amateras.uml.sequencediagram.editpart.InstanceOutgoingConnectionAnchor;
import net.java.amateras.uml.sequencediagram.editpart.MessageIncomingConnectionAnchor;
import net.java.amateras.uml.sequencediagram.editpart.MessageOutgoingConnectionAnchor;
import net.java.amateras.uml.sequencediagram.editpart.OutgoingFeedbackAnchor;
import net.java.amateras.uml.sequencediagram.editpart.ReturnMessageIncomingAnchor;
import net.java.amateras.uml.sequencediagram.editpart.ReturnMessageOutgoingAnchor;
import net.java.amateras.uml.sequencediagram.figure.SequenceFigureFactory;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.model.MessageOrderUtil;
import net.java.amateras.uml.sequencediagram.model.ReturnMessageModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;

public class ActivationEditPart
extends AbstractUMLEntityEditPart {
    private static Color highLightColor = new Color(null, 200, 200, 240);

    protected IFigure createFigure() {
        return SequenceFigureFactory.getActivationFigure();
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivationNodeEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("_constraint")) {
            this.refreshVisuals();
        }
        if (evt.getPropertyName().equals("_source_connection")) {
            this.refreshSourceConnections();
        }
        if (evt.getPropertyName().equals("_target_connection")) {
            this.refreshTargetConnections();
        }
    }

    private ActivationModel getActivation() {
        return (ActivationModel)this.getModel();
    }

    @Override
    protected List<AbstractUMLConnectionModel> getModelSourceConnections() {
        return this.getActivation().getModelSourceConnections();
    }

    @Override
    protected List<AbstractUMLConnectionModel> getModelTargetConnections() {
        return this.getActivation().getModelTargetConnections();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        MessageModel model = (MessageModel)connection.getModel();
        if (model instanceof SyncMessageModel) {
            if (model.getTarget() instanceof InstanceModel) {
                return new InstanceOutgoingConnectionAnchor(this.getFigure(), model.getTarget());
            }
            return new MessageOutgoingConnectionAnchor(this.getFigure(), model.getTarget());
        }
        if (model instanceof ReturnMessageModel) {
            return new ReturnMessageOutgoingAnchor(this.getFigure(), model.getTarget());
        }
        return null;
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        MessageModel model = (MessageModel)connection.getModel();
        if (model instanceof SyncMessageModel) {
            return new MessageIncomingConnectionAnchor(this.getFigure(), model.getSource());
        }
        if (model instanceof ReturnMessageModel) {
            return new ReturnMessageIncomingAnchor(this.getFigure(), model.getSource());
        }
        return null;
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest) {
            DropRequest connectionRequest = (DropRequest)request;
            Point point = connectionRequest.getLocation();
            Point in = point.getCopy();
            this.getFigure().translateToRelative((Translatable)in);
            return new OutgoingFeedbackAnchor(this.getFigure(), in);
        }
        return new ChopboxAnchor(this.getFigure());
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest connectionRequest = (CreateConnectionRequest)request;
            ConnectionCommand command = (ConnectionCommand)connectionRequest.getStartCommand();
            return new IncomingFeedbackAnchor(this.getFigure(), command.getPoint().getCopy());
        }
        return null;
    }

    private class ActivationNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        private ActivationNodeEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            CreateCompleteCommand command = new CreateCompleteCommand();
            ConnectionCommand locationCommand = (ConnectionCommand)request.getStartCommand();
            command.setPoint(locationCommand.getPoint());
            command.setModel(locationCommand.getModel());
            command.setSource(locationCommand.getSource());
            return locationCommand.chain(command);
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            ConnectionCommand command = new ConnectionCommand();
            command.setSource(ActivationEditPart.this.getActivation());
            Point p = request.getLocation().getCopy();
            ActivationEditPart.this.getFigure().translateToRelative((Translatable)p);
            command.setPoint(p);
            command.setModel((MessageModel)request.getNewObject());
            request.setStartCommand((Command)command);
            return command;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            return null;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            return null;
        }
    }

    private class CreateCompleteCommand
    extends ConnectionCommand {
        private ActivationModel target;
        private ReturnMessageModel returnMessage;

        private CreateCompleteCommand() {
        }

        public boolean canExecute() {
            List<AbstractUMLConnectionModel> connections = this.getSource().getModelSourceConnections();
            for (MessageModel messageModel : connections) {
                if (!(messageModel instanceof SyncMessageModel) || !ActivationEditPart.this.getActivation().equals(messageModel.getTarget())) continue;
                return false;
            }
            if (this.getSource() instanceof ActivationModel) {
                ActivationModel model = (ActivationModel)this.getSource();
                LifeLineModel lifeLineModel = model.getOwnerLine();
                LifeLineModel ownerLine = ActivationEditPart.this.getActivation().getOwnerLine();
                if (lifeLineModel == null) {
                    return false;
                }
                if (lifeLineModel.equals(ownerLine) && !model.equals(ActivationEditPart.this.getActivation())) {
                    return false;
                }
            }
            return true;
        }

        public void execute() {
            Rectangle rectangle = this.createActivation();
            this.getModel().setSource(this.getSource());
            this.getModel().setTarget(this.target);
            this.getModel().attachSource();
            this.getModel().attachTarget();
            ActivationEditPart.this.getActivation().copyPresentation(this.getModel());
            SyncMessageModel sync = (SyncMessageModel)this.getModel();
            if (sync.isRecursive()) {
                rectangle.translate(0, 20);
            } else if (UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.sequence.createreturn")) {
                this.createReturnMessage();
            }
            this.computeConstraint(rectangle);
        }

        private void computeConstraint(Rectangle rectangle) {
            this.target.setConstraint(rectangle.translate(10, 0));
            MessageOrderUtil.computeMessageOrders(this.target.getRoot());
            this.target.getRoot().adjustLifeLine();
        }

        private void createReturnMessage() {
            this.returnMessage = new ReturnMessageModel();
            this.returnMessage.setSource(this.target);
            this.returnMessage.setTarget(this.getSource());
            this.returnMessage.attachSource();
            this.returnMessage.attachTarget();
            this.target.copyPresentation(this.returnMessage);
        }

        private Rectangle createActivation() {
            this.target = new ActivationModel();
            Dimension dimension = new Dimension(10, 20);
            Point p = ActivationEditPart.this.getActivation().getConstraint().getTopLeft().getCopy();
            Point mouseP = this.getPoint().getCopy();
            p.y = mouseP.y;
            Rectangle rectangle = new Rectangle(p.translate(-5, 0), dimension);
            ActivationEditPart.this.getActivation().copyPresentation(this.target);
            ActivationEditPart.this.getActivation().addActivation(this.target);
            return rectangle;
        }

        public void undo() {
            SyncMessageModel sync = (SyncMessageModel)this.getModel();
            if (!sync.isRecursive() && this.returnMessage != null) {
                this.returnMessage.detachSource();
                this.returnMessage.detachTarget();
            }
            ActivationModel act = (ActivationModel)this.getModel().getSource();
            this.getModel().detachSource();
            this.getModel().detachTarget();
            act.computeCaller();
            ActivationEditPart.this.getActivation().removeActivation(this.target);
            ActivationEditPart.this.getActivation().getRoot().adjustLifeLine();
            MessageOrderUtil.computeMessageOrders(ActivationEditPart.this.getActivation().getRoot());
        }
    }

    private class HighlightEditPolicy
    extends GraphicalEditPolicy {
        private Color revertColor;

        private HighlightEditPolicy() {
        }

        public void eraseTargetFeedback(Request request) {
            if (this.revertColor != null) {
                this.setContainerBackground(this.revertColor);
                this.revertColor = null;
            }
        }

        private Color getContainerBackground() {
            return this.getContainerFigure().getBackgroundColor();
        }

        private IFigure getContainerFigure() {
            return ((GraphicalEditPart)this.getHost()).getFigure();
        }

        public EditPart getTargetEditPart(Request request) {
            return request.getType().equals("selection hover") ? this.getHost() : null;
        }

        private void setContainerBackground(Color c) {
            this.getContainerFigure().setBackgroundColor(c);
        }

        protected void showHighlight() {
            if (this.revertColor == null) {
                this.revertColor = this.getContainerBackground();
                this.setContainerBackground(highLightColor);
            }
        }

        public void showTargetFeedback(Request request) {
            if (request.getType().equals("connection end") || request.getType().equals("connection start")) {
                this.showHighlight();
            }
        }
    }
}

