/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.AbstractUMLEntityEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.sequencediagram.editpart.ConnectionCommand;
import net.java.amateras.uml.sequencediagram.editpart.InstanceIncomingConnectionAnchor;
import net.java.amateras.uml.sequencediagram.figure.ActorFigure;
import net.java.amateras.uml.sequencediagram.figure.InstanceFigure;
import net.java.amateras.uml.sequencediagram.figure.SequenceFigureFactory;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.ActorModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.model.MessageOrderUtil;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class InstanceEditPart
extends AbstractUMLEntityEditPart {
    protected IFigure createFigure() {
        InstanceModel model = (InstanceModel)this.getModel();
        InstanceFigure figure = null;
        figure = model instanceof ActorModel ? new ActorFigure().build() : SequenceFigureFactory.getInstanceFigure().build();
        figure.setInstanceName(model.getName());
        if (model.getType() != null) {
            if (this.showSimpleName()) {
                figure.setTypeName(model.getType().getSimpleName());
            } else {
                figure.setTypeName(model.getType().getName());
            }
        } else {
            figure.setTypeName("");
        }
        return figure;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                InstanceModel model = (InstanceModel)InstanceEditPart.this.getModel();
                List<AbstractUMLModel> list = model.getModel().getChildren();
                for (AbstractUMLEntityModel abstractUMLEntityModel : list) {
                    if (abstractUMLEntityModel.getModelSourceConnections().isEmpty()) continue;
                    return null;
                }
                DeleteCommand command = new DeleteCommand();
                command.setModel(model);
                return command;
            }
        });
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new InstanceNodeEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_instance_name") || evt.getPropertyName().equals("_type")) {
            this.refreshName();
        }
        super.propertyChange(evt);
    }

    private boolean showSimpleName() {
        return UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.sequence.simplename");
    }

    private InstanceModel getInstance() {
        return (InstanceModel)this.getModel();
    }

    private void refreshName() {
        InstanceModel model = (InstanceModel)this.getModel();
        InstanceFigure figure = (InstanceFigure)this.getFigure();
        String name = model.getName();
        figure.setInstanceName(name);
        if (model.getType() != null) {
            if (this.showSimpleName()) {
                figure.setTypeName(model.getType().getSimpleName());
            } else {
                figure.setTypeName(model.getType().getName());
            }
        } else {
            figure.setTypeName("");
        }
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        MessageModel model = (MessageModel)connection.getModel();
        if (model instanceof SyncMessageModel) {
            return new InstanceIncomingConnectionAnchor(this.getFigure(), model.getSource());
        }
        return null;
    }

    private class CreateCompleteCommand
    extends ConnectionCommand {
        private ActivationModel newModel;

        private CreateCompleteCommand() {
        }

        public boolean canExecute() {
            InstanceModel model = InstanceEditPart.this.getInstance();
            List<AbstractUMLModel> list = model.getModel().getChildren();
            for (AbstractUMLEntityModel abstractUMLEntityModel : list) {
                if (abstractUMLEntityModel.getModelSourceConnections().isEmpty()) continue;
                return false;
            }
            return true;
        }

        public void execute() {
            Rectangle rectangle = InstanceEditPart.this.getInstance().getConstraint().getCopy();
            Point p = rectangle.getTopLeft();
            p.y = this.getPoint().y;
            rectangle.setLocation(p);
            InstanceEditPart.this.getInstance().setConstraint(rectangle);
            this.getModel().setSource(this.getSource());
            this.getModel().setTarget(InstanceEditPart.this.getInstance());
            this.getModel().attachSource();
            this.getModel().attachTarget();
            ActivationModel act = (ActivationModel)this.getSource();
            act.computeCaller();
            this.newModel = new ActivationModel();
            this.newModel.setMovable(false);
            Point actP = rectangle.getBottom().getCopy().getTranslated(-5, 20);
            Rectangle newRect = new Rectangle(actP, new Dimension(10, 20));
            InstanceEditPart.this.getInstance().copyPresentation(this.newModel);
            InstanceEditPart.this.getInstance().getModel().addActivation(this.newModel);
            InstanceEditPart.this.getInstance().setActive(this.newModel);
            this.newModel.setConstraint(newRect);
            MessageOrderUtil.computeMessageOrders(InstanceEditPart.this.getInstance().getRoot());
            super.execute();
        }

        public void undo() {
            super.undo();
            ActivationModel act = (ActivationModel)this.getSource();
            this.getModel().detachSource();
            this.getModel().detachTarget();
            act.computeCaller();
            Rectangle rectangle = InstanceEditPart.this.getInstance().getConstraint().getCopy();
            Point p = rectangle.getTopLeft();
            p.y = 20;
            rectangle.setLocation(p);
            InstanceEditPart.this.getInstance().setConstraint(rectangle);
            InstanceEditPart.this.getInstance().getModel().removeActivation(this.newModel);
            InstanceEditPart.this.getInstance().setActive(null);
            MessageOrderUtil.computeMessageOrders(InstanceEditPart.this.getInstance().getRoot());
        }
    }

    class DeleteCommand
    extends Command {
        InstanceModel model;
        LifeLineModel lineModel;
        InteractionModel interactionModel;

        DeleteCommand() {
        }

        public void setModel(InstanceModel model) {
            this.model = model;
            this.lineModel = model.getModel();
            this.interactionModel = model.getRoot();
        }

        public void execute() {
            super.execute();
            this.interactionModel.removeInstance(this.model);
            this.interactionModel.removeLifeLine(this.lineModel);
        }

        public void undo() {
            super.undo();
            this.interactionModel.addInstance(this.model);
        }
    }

    class InstanceNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        InstanceNodeEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            CreateCompleteCommand command = new CreateCompleteCommand();
            ConnectionCommand locationCommand = (ConnectionCommand)request.getStartCommand();
            command.setPoint(locationCommand.getPoint());
            command.setModel(locationCommand.getModel());
            command.setSource(locationCommand.getSource());
            return locationCommand.chain(command);
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            return null;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            return null;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            return null;
        }
    }
}

