/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.ActorModel;
import net.java.amateras.uml.sequencediagram.model.FragmentModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageOrderUtil;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

public class InteractionEditPart
extends AbstractUMLEditPart {
    private static Layer layer;

    public static Layer getLayer() {
        return layer;
    }

    protected IFigure createFigure() {
        layer = new Layer(){

            public void paint(Graphics graphics) {
                if (UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.antialias")) {
                    graphics.setAntialias(1);
                    graphics.setTextAntialias(1);
                }
                super.paint(graphics);
            }
        };
        layer.setLayoutManager((LayoutManager)new FreeformLayout());
        return layer;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DelegateLayoutEditPolicy());
    }

    protected List<?> getModelChildren() {
        ArrayList<Object> rv = new ArrayList<Object>();
        rv.addAll(this.getInteraction().getFragments());
        rv.addAll(this.getInteraction().getLifeLines());
        rv.addAll(this.getInteraction().getActivations());
        rv.addAll(this.getInteraction().getInstances());
        rv.addAll(this.getInteraction().getNotes());
        return rv;
    }

    private InteractionModel getInteraction() {
        return (InteractionModel)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshChildren();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return (SnapToHelper)snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    private class ActivationEditPolicy
    extends DelegateLayoutEditPolicy {
        public ActivationEditPolicy(DelegateLayoutEditPolicy owner) {
            super(owner);
        }

        @Override
        protected EditPolicy createChildEditPolicyDelegate(EditPart arg0) {
            return new NonResizableEditPolicy();
        }

        @Override
        protected Command createChangeConstraintCommandDelegate(EditPart arg0, Object arg1) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            ActivationModel model = (ActivationModel)arg0.getModel();
            Rectangle rectangle = (Rectangle)arg1;
            ActivationModel owner = model.getOwner();
            if (owner != null) {
                Rectangle constraint = owner.getConstraint();
                if (rectangle.y < constraint.y) {
                    rectangle.y = constraint.y;
                }
            }
            rectangle.setLocation(model.getConstraint().x, rectangle.y);
            command.setConstraint(rectangle);
            command.setModel(model);
            if (model.isMovable()) {
                return command;
            }
            return null;
        }
    }

    private class ChangeConstraintCommand
    extends Command {
        private AbstractUMLEntityModel model;
        private Rectangle constraint;
        private Rectangle oldConstraint;

        private ChangeConstraintCommand() {
        }

        public void execute() {
            this.model.setConstraint(this.constraint);
            MessageOrderUtil.computeMessageOrders(InteractionEditPart.this.getInteraction());
            InteractionEditPart.this.getInteraction().adjustLifeLine();
        }

        public void setConstraint(Rectangle constraint) {
            this.constraint = constraint;
        }

        public void setModel(AbstractUMLEntityModel model) {
            this.model = model;
            this.oldConstraint = model.getConstraint();
        }

        public void undo() {
            this.model.setConstraint(this.oldConstraint);
        }
    }

    private class CreateCommand
    extends Command {
        private InteractionModel root;
        private AbstractUMLModel model;

        private CreateCommand() {
        }

        public void execute() {
            this.root.addUMLModel(this.model);
            this.root.copyPresentation(this.model);
            MessageOrderUtil.computeMessageOrders(InteractionEditPart.this.getInteraction());
        }

        public void setRoot(InteractionModel root) {
            this.root = root;
        }

        public void setModel(AbstractUMLModel model) {
            this.model = model;
        }

        public void undo() {
            this.root.removeUMLModel(this.model);
        }
    }

    private class DelegateLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private Map delegates = new HashMap();
        private DelegateLayoutEditPolicy owner;

        DelegateLayoutEditPolicy() {
            this.delegates.put(InstanceModel.class, new InstanceEditPolicy(this));
            this.delegates.put(ActorModel.class, new InstanceEditPolicy(this));
            this.delegates.put(LifeLineModel.class, new LifeLineEditPolicy(this));
            this.delegates.put(FragmentModel.class, new FragmentEditPolicy(this));
            this.delegates.put(ActivationModel.class, new ActivationEditPolicy(this));
            this.delegates.put(NoteModel.class, new NoteEditPolicy(this));
        }

        DelegateLayoutEditPolicy(DelegateLayoutEditPolicy owner) {
            this.owner = owner;
        }

        protected DelegateLayoutEditPolicy getOwner() {
            return this.owner;
        }

        protected Command createAddCommand(EditPart child, Object constraint) {
            return null;
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            DelegateLayoutEditPolicy delegate = (DelegateLayoutEditPolicy)((Object)this.delegates.get(child.getModel().getClass()));
            return delegate != null ? delegate.createChildEditPolicyDelegate(child) : null;
        }

        protected EditPolicy createChildEditPolicyDelegate(EditPart child) {
            return null;
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            DelegateLayoutEditPolicy delegate = (DelegateLayoutEditPolicy)((Object)this.delegates.get(child.getModel().getClass()));
            return delegate != null ? delegate.createChangeConstraintCommandDelegate(child, constraint) : null;
        }

        protected Command createChangeConstraintCommandDelegate(EditPart child, Object constraint) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            DelegateLayoutEditPolicy delegate = (DelegateLayoutEditPolicy)((Object)this.delegates.get(request.getNewObjectType()));
            return delegate != null ? delegate.getCreateCommandDelegate(request, this.getConstraintFor(request)) : null;
        }

        protected Command getCreateCommandDelegate(CreateRequest request, Object constraint) {
            return null;
        }

        protected Command getDeleteDependantCommand(Request request) {
            return null;
        }
    }

    private class FragmentEditPolicy
    extends DelegateLayoutEditPolicy {
        public FragmentEditPolicy(DelegateLayoutEditPolicy owner) {
            super(owner);
        }

        @Override
        protected EditPolicy createChildEditPolicyDelegate(EditPart arg0) {
            return new ResizableEditPolicy();
        }

        @Override
        protected Command getCreateCommandDelegate(CreateRequest arg0, Object arg1) {
            FragmentModel object = (FragmentModel)arg0.getNewObject();
            CreateCommand command = new CreateCommand();
            object.setConstraint((Rectangle)arg1);
            command.setModel(object);
            command.setRoot((InteractionModel)this.getOwner().getHost().getModel());
            return command;
        }

        @Override
        protected Command createChangeConstraintCommandDelegate(EditPart arg0, Object arg1) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            FragmentModel model = (FragmentModel)arg0.getModel();
            Rectangle rectangle = (Rectangle)arg1;
            command.setModel(model);
            command.setConstraint(rectangle);
            return command;
        }
    }

    private class InstanceEditPolicy
    extends DelegateLayoutEditPolicy {
        public InstanceEditPolicy(DelegateLayoutEditPolicy owner) {
            super(owner);
        }

        @Override
        protected EditPolicy createChildEditPolicyDelegate(EditPart arg0) {
            return new ResizableEditPolicy();
        }

        @Override
        protected Command createChangeConstraintCommandDelegate(EditPart arg0, Object arg1) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            InstanceModel model = (InstanceModel)arg0.getModel();
            Rectangle rectangle = (Rectangle)arg1;
            if (model.getModelTargetConnections().isEmpty()) {
                rectangle.setLocation(rectangle.x, model.getConstraint().y);
            }
            if (rectangle.getSize() != null) {
                rectangle.setSize(rectangle.getSize().width, model.getConstraint().height);
            }
            command.setConstraint(rectangle);
            command.setModel(model);
            return command;
        }

        @Override
        protected Command getCreateCommandDelegate(CreateRequest request, Object constraint) {
            CompoundCommand rv = new CompoundCommand("create Instance And Lifeline");
            CreateCommand command = new CreateCommand();
            Rectangle rectangle = (Rectangle)constraint;
            rectangle.width = 100;
            rectangle.height = -1;
            rectangle.y = 20;
            InstanceModel model = (InstanceModel)request.getNewObject();
            model.setConstraint(rectangle);
            command.setRoot((InteractionModel)this.getOwner().getHost().getModel());
            command.setModel(model);
            rv.add((Command)command);
            command = new CreateCommand();
            command.setRoot((InteractionModel)this.getOwner().getHost().getModel());
            command.setModel(model.getModel());
            Rectangle lineRect = rectangle.getCopy();
            lineRect.translate(new Point(50, 0));
            lineRect.width = 5;
            lineRect.height = 200;
            model.getModel().setConstraint(lineRect);
            return rv;
        }
    }

    private class LifeLineEditPolicy
    extends DelegateLayoutEditPolicy {
        public LifeLineEditPolicy(DelegateLayoutEditPolicy owner) {
            super(owner);
        }

        @Override
        protected EditPolicy createChildEditPolicy(EditPart arg0) {
            return super.createChildEditPolicy(arg0);
        }

        @Override
        protected Command createChangeConstraintCommand(EditPart arg0, Object arg1) {
            return super.createChangeConstraintCommand(arg0, arg1);
        }
    }

    private class NoteEditPolicy
    extends DelegateLayoutEditPolicy {
        public NoteEditPolicy(DelegateLayoutEditPolicy owner) {
            super(owner);
        }

        @Override
        protected EditPolicy createChildEditPolicyDelegate(EditPart arg0) {
            return new ResizableEditPolicy();
        }

        @Override
        protected Command getCreateCommandDelegate(CreateRequest arg0, Object arg1) {
            NoteModel object = (NoteModel)arg0.getNewObject();
            CreateCommand command = new CreateCommand();
            object.setConstraint((Rectangle)arg1);
            command.setModel(object);
            command.setRoot((InteractionModel)this.getOwner().getHost().getModel());
            return command;
        }

        @Override
        protected Command createChangeConstraintCommandDelegate(EditPart arg0, Object arg1) {
            ChangeConstraintCommand command = new ChangeConstraintCommand();
            NoteModel model = (NoteModel)arg0.getModel();
            Rectangle rectangle = (Rectangle)arg1;
            command.setModel(model);
            command.setConstraint(rectangle);
            return command;
        }
    }
}

