/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.editpart;

import java.beans.PropertyChangeEvent;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.editpart.AbstractUMLEditPart;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.sequencediagram.editpart.ConnectionCommand;
import net.java.amateras.uml.sequencediagram.editpart.IncomingFeedbackAnchor;
import net.java.amateras.uml.sequencediagram.editpart.InteractionEditPart;
import net.java.amateras.uml.sequencediagram.editpart.OutgoingFeedbackAnchor;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.model.MessageOrderUtil;
import net.java.amateras.uml.sequencediagram.model.ReturnMessageModel;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;

public class LifeLineEditPart
extends AbstractUMLEditPart
implements NodeEditPart {
    private static Color highLightColor = new Color(null, 0, 0, 240);
    private int width = 2;

    protected IFigure createFigure() {
        Figure figure = new Figure(){

            public void paint(Graphics graphics) {
                if (UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.antialias")) {
                    graphics.setAntialias(1);
                    graphics.setTextAntialias(1);
                }
                super.paint(graphics);
            }

            protected void paintFigure(Graphics graphics) {
                Rectangle rectangle = this.getClientArea().getCopy();
                graphics.setLineStyle(3);
                graphics.setLineWidth(LifeLineEditPart.this.width);
                graphics.drawLine(rectangle.getTopLeft().translate(0, 10), rectangle.getBottomLeft());
            }
        };
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new LifeLineNodeEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_constraint")) {
            this.refreshVisuals();
        }
    }

    @Override
    protected void refreshVisuals() {
        Object model = this.getModel();
        if (model instanceof AbstractUMLEntityModel) {
            Rectangle constraint = ((AbstractUMLEntityModel)model).getConstraint();
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)constraint);
        }
    }

    private LifeLineModel getLifeLine() {
        return (LifeLineModel)this.getModel();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest) {
            DropRequest connectionRequest = (DropRequest)request;
            Point point = connectionRequest.getLocation();
            return new OutgoingFeedbackAnchor(this.getFigure(), point.getCopy());
        }
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest connectionRequest = (CreateConnectionRequest)request;
            ConnectionCommand command = (ConnectionCommand)connectionRequest.getStartCommand();
            return new IncomingFeedbackAnchor(this.getFigure(), command.getPoint().getCopy());
        }
        return null;
    }

    private class CreateCompleteCommand
    extends ConnectionCommand {
        private ActivationModel newModel;
        private ReturnMessageModel returnMessage;

        private CreateCompleteCommand() {
        }

        public boolean canExecute() {
            AbstractUMLEntityModel entityModel = this.getSource();
            if (entityModel instanceof ActivationModel) {
                ActivationModel model = (ActivationModel)entityModel;
                if (LifeLineEditPart.this.getLifeLine().equals(model.getOwnerLine())) {
                    return false;
                }
            }
            return super.canExecute();
        }

        public void execute() {
            this.newModel = new ActivationModel();
            Dimension dimension = new Dimension(10, 20);
            Point p = LifeLineEditPart.this.getLifeLine().getConstraint().getTopLeft().getCopy();
            Point mouseP = this.getPoint().getCopy();
            p.y = mouseP.y;
            LifeLineEditPart.this.getLifeLine().addActivation(this.newModel);
            this.getModel().setSource(this.getSource());
            this.getModel().setTarget(this.newModel);
            this.getModel().attachSource();
            this.getModel().attachTarget();
            if (UMLPlugin.getDefault().getPreferenceStore().getBoolean("pref.sequence.createreturn")) {
                this.createReturnMessage();
            }
            this.newModel.setConstraint(new Rectangle(p.translate(-5, 0), dimension));
            this.newModel.computeCaller();
            this.newModel.getRoot().adjustLifeLine();
            LifeLineEditPart.this.getLifeLine().copyPresentation(this.newModel);
            MessageOrderUtil.computeMessageOrders(LifeLineEditPart.this.getLifeLine().getOwner().getRoot());
        }

        private void createReturnMessage() {
            this.returnMessage = new ReturnMessageModel();
            this.returnMessage.setSource(this.newModel);
            this.returnMessage.setTarget(this.getSource());
            this.returnMessage.attachSource();
            this.returnMessage.attachTarget();
        }

        public void undo() {
            ActivationModel model = (ActivationModel)this.getModel().getSource();
            this.getModel().detachSource();
            this.getModel().detachTarget();
            if (this.returnMessage != null) {
                this.returnMessage.detachSource();
                this.returnMessage.detachTarget();
            }
            model.computeCaller();
            this.newModel.getRoot().adjustLifeLine();
            LifeLineEditPart.this.getLifeLine().removeActivation(this.newModel);
            MessageOrderUtil.computeMessageOrders(LifeLineEditPart.this.getLifeLine().getOwner().getRoot());
        }
    }

    private class CreateConnectionFeedbackCommand
    extends ConnectionCommand {
        private CreateConnectionFeedbackCommand() {
        }

        public boolean canExecute() {
            return true;
        }

        public void execute() {
            Dimension dimension = new Dimension(10, 20);
            Point p = LifeLineEditPart.this.getLifeLine().getConstraint().getTopLeft().getCopy();
            Point mouseP = this.getPoint().getCopy();
            InteractionEditPart.getLayer().translateToRelative((Translatable)mouseP);
            p.y = mouseP.y;
            this.getSource().setConstraint(new Rectangle(p.translate(-5, 0), dimension));
            LifeLineEditPart.this.getLifeLine().addActivation((ActivationModel)this.getSource());
        }

        public void undo() {
            LifeLineEditPart.this.getLifeLine().removeActivation((ActivationModel)this.getSource());
        }
    }

    private class HighlightEditPolicy
    extends GraphicalEditPolicy {
        private Color revertColor;

        private HighlightEditPolicy() {
        }

        public void eraseTargetFeedback(Request request) {
            if (this.revertColor != null) {
                LifeLineEditPart.this.width = 2;
                this.setContainerForeground(this.revertColor);
                this.revertColor = null;
            }
        }

        private Color getContainerForeground() {
            return this.getContainerFigure().getForegroundColor();
        }

        private IFigure getContainerFigure() {
            return ((GraphicalEditPart)this.getHost()).getFigure();
        }

        public EditPart getTargetEditPart(Request request) {
            return request.getType().equals("selection hover") ? this.getHost() : null;
        }

        private void setContainerForeground(Color c) {
            this.getContainerFigure().setForegroundColor(c);
        }

        protected void showHighlight() {
            if (this.revertColor == null) {
                LifeLineEditPart.this.width = 3;
                this.revertColor = this.getContainerForeground();
                this.setContainerForeground(highLightColor);
            }
        }

        public void showTargetFeedback(Request request) {
            if (request.getType().equals("connection start") || request.getType().equals("connection end")) {
                this.showHighlight();
            }
        }
    }

    private class LifeLineNodeEditPolicy
    extends GraphicalNodeEditPolicy {
        private LifeLineNodeEditPolicy() {
        }

        protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
            CreateCompleteCommand command = new CreateCompleteCommand();
            ConnectionCommand locationCommand = (ConnectionCommand)request.getStartCommand();
            command.setSource(locationCommand.getSource());
            command.setPoint(locationCommand.getPoint());
            command.setModel(locationCommand.getModel());
            return locationCommand.chain(command);
        }

        protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
            CreateConnectionFeedbackCommand command = new CreateConnectionFeedbackCommand();
            ActivationModel newModel = new ActivationModel();
            LifeLineEditPart.this.getLifeLine().copyPresentation(newModel);
            command.setPoint(request.getLocation());
            command.setModel((MessageModel)request.getNewObject());
            command.setSource(newModel);
            request.setStartCommand((Command)command);
            return command;
        }

        protected Command getReconnectTargetCommand(ReconnectRequest request) {
            return null;
        }

        protected Command getReconnectSourceCommand(ReconnectRequest request) {
            return null;
        }
    }
}

