/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.editpart;

import java.util.List;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageAcceptableModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.model.ReturnMessageModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class MessageComponentEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        MessageModel model = (MessageModel)this.getHost().getModel();
        Command command = this.createDeleteMessageCommand(model);
        return command;
    }

    private Command createDeleteActivationCommand(ActivationModel model) {
        CompoundCommand command = new CompoundCommand();
        List<SyncMessageModel> sourceConnections = model.getSyncSourceConnection();
        for (MessageModel messageModel : sourceConnections) {
            command.add(this.createDeleteMessageCommand(messageModel));
        }
        DeleteActivationCommand activationCommand = new DeleteActivationCommand();
        activationCommand.setModel(model);
        command.add((Command)activationCommand);
        List<SyncMessageModel> list = model.getSyncTargetConnection();
        for (SyncMessageModel sync : list) {
            ActivationModel source = (ActivationModel)sync.getSource();
            if (!source.getSyncTargetConnection().isEmpty() || source.getSyncSourceConnection().size() != 1) continue;
            DeleteActivationCommand sourceCommand = new DeleteActivationCommand();
            sourceCommand.setModel(source);
            command.add((Command)sourceCommand);
        }
        return command.unwrap();
    }

    private Command createDeleteMessageCommand(MessageModel model) {
        if (model.getTarget() instanceof ActivationModel) {
            Command command = this.createDeleteActivationCommand((ActivationModel)model.getTarget());
            DeleteMessageCommand messageCommand = new DeleteMessageCommand();
            messageCommand.setModel(model);
            return messageCommand.chain(command);
        }
        if (model.getTarget() instanceof InstanceModel) {
            Command command = this.createDeleteInstaciateCommand((InstanceModel)model.getTarget(), model);
            DeleteMessageCommand messageCommand = new DeleteMessageCommand();
            messageCommand.setModel(model);
            return messageCommand.chain(command);
        }
        DeleteMessageCommand messageCommand = new DeleteMessageCommand();
        messageCommand.setModel(model);
        return messageCommand;
    }

    private Command createDeleteInstaciateCommand(InstanceModel model, MessageModel msg) {
        ActivationModel active = model.getActive();
        CompoundCommand command = new CompoundCommand();
        List<SyncMessageModel> sourceConnections = active.getSyncSourceConnection();
        for (MessageModel messageModel : sourceConnections) {
            command.add(this.createDeleteMessageCommand(messageModel));
        }
        DeleteInstanciationCommnad instanceCommand = new DeleteInstanciationCommnad();
        instanceCommand.setOwner(model);
        instanceCommand.setModel(active);
        command.add((Command)instanceCommand);
        ActivationModel activationModel = (ActivationModel)msg.getSource();
        if (activationModel.getSyncTargetConnection().isEmpty() && activationModel.getSyncSourceConnection().size() == 1) {
            DeleteActivationCommand sourceCommand = new DeleteActivationCommand();
            sourceCommand.setModel(activationModel);
            command.add((Command)sourceCommand);
        }
        return command.unwrap();
    }

    private class DeleteActivationCommand
    extends Command {
        ActivationModel model;
        ActivationModel owner;
        LifeLineModel lifeLine;
        ReturnMessageModel returnMessageModel;

        private DeleteActivationCommand() {
        }

        public void setModel(ActivationModel model) {
            this.model = model;
            List<AbstractUMLConnectionModel> connections = model.getModelSourceConnections();
            for (AbstractUMLConnectionModel element : connections) {
                if (!(element instanceof ReturnMessageModel)) continue;
                this.returnMessageModel = (ReturnMessageModel)element;
            }
        }

        public void execute() {
            if (!this.model.isMovable()) {
                return;
            }
            this.owner = this.model.getOwner();
            if (this.owner != null) {
                this.owner.removeActivation(this.model);
            } else {
                this.lifeLine = this.model.getOwnerLine();
                this.lifeLine.removeActivation(this.model);
            }
            if (this.returnMessageModel != null) {
                this.returnMessageModel.detachSource();
                this.returnMessageModel.detachTarget();
            }
        }

        public void undo() {
            if (!this.model.isMovable()) {
                return;
            }
            if (this.owner != null) {
                this.owner.addActivation(this.model);
            } else {
                this.lifeLine.addActivation(this.model);
            }
            if (this.returnMessageModel != null) {
                this.returnMessageModel.attachSource();
                this.returnMessageModel.attachTarget();
            }
        }
    }

    private class DeleteInstanciationCommnad
    extends Command {
        InstanceModel owner;
        ActivationModel model;

        private DeleteInstanciationCommnad() {
        }

        public void setModel(ActivationModel model) {
            this.model = model;
        }

        public void setOwner(InstanceModel owner) {
            this.owner = owner;
        }

        public void execute() {
            this.owner.setActive(null);
            this.owner.getModel().removeActivation(this.model);
        }

        public void undo() {
            this.owner.setActive(this.model);
            this.owner.getModel().addActivation(this.model);
        }
    }

    private class DeleteMessageCommand
    extends Command {
        private MessageModel model;

        private DeleteMessageCommand() {
        }

        public void setModel(MessageModel model) {
            this.model = model;
        }

        public void execute() {
            MessageAcceptableModel activationModel = (MessageAcceptableModel)this.model.getSource();
            MessageAcceptableModel targetModel = (MessageAcceptableModel)this.model.getTarget();
            this.model.detachSource();
            this.model.detachTarget();
            activationModel.computeCaller();
            targetModel.computeCaller();
        }

        public void undo() {
            this.model.attachSource();
            this.model.attachTarget();
            MessageAcceptableModel activationModel = (MessageAcceptableModel)this.model.getTarget();
            MessageAcceptableModel targetModel = (MessageAcceptableModel)this.model.getTarget();
            activationModel.computeCaller();
            targetModel.computeCaller();
        }
    }
}

