/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.amateras.uml.figure.EntityFigure;
import net.java.amateras.uml.figure.PresentationFigure;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.property.MessageTextCellEditor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

public class MessageEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private EntityDirectEditManager directManager = null;

    public void activate() {
        super.activate();
        ((AbstractUMLModel)this.getModel()).addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        ((AbstractUMLModel)this.getModel()).removePropertyChangeListener(this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new EntityDirectEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void refreshVisuals() {
        if (this.getFigure() instanceof PresentationFigure) {
            PresentationFigure figure = (PresentationFigure)this.getFigure();
            figure.updatePresentation((AbstractUMLModel)this.getModel());
        }
        super.refreshVisuals();
    }

    public void performRequest(Request req) {
        if (this.getModel() instanceof EntityModel && (req.getType().equals("direct edit") || req.getType().equals("open"))) {
            this.performDirectEdit();
            return;
        }
        super.performRequest(req);
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            this.directManager = new EntityDirectEditManager();
        }
        this.directManager.show();
    }

    private class DirectEditCommand
    extends Command {
        private String oldName;
        private String newName;

        private DirectEditCommand() {
        }

        public void execute() {
            EntityModel model = (EntityModel)MessageEditPart.this.getModel();
            this.oldName = model.getName();
            model.setName(this.newName);
        }

        public void setName(String name) {
            this.newName = name;
        }

        public void undo() {
            EntityModel model = (EntityModel)MessageEditPart.this.getModel();
            model.setName(this.oldName);
        }
    }

    private class EntityCellEditorLocator
    implements CellEditorLocator {
        private EntityCellEditorLocator() {
        }

        public void relocate(CellEditor celleditor) {
            EntityFigure figure = (EntityFigure)MessageEditPart.this.getFigure();
            Text text = (Text)celleditor.getControl();
            Rectangle rect = figure.getCellEditorRectangle();
            figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y, rect.width, rect.height);
        }
    }

    private class EntityDirectEditManager
    extends DirectEditManager {
        public EntityDirectEditManager() {
            super((GraphicalEditPart)MessageEditPart.this, MessageTextCellEditor.class, (CellEditorLocator)new EntityCellEditorLocator());
        }

        protected void initCellEditor() {
            MessageTextCellEditor cellEditor = (MessageTextCellEditor)this.getCellEditor();
            MessageModel model = (MessageModel)MessageEditPart.this.getModel();
            cellEditor.setUMLModel(model.getProporsal());
            this.getCellEditor().setValue((Object)model.getName());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class EntityDirectEditPolicy
    extends DirectEditPolicy {
        private EntityDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setName((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

