/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageAcceptableModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import org.eclipse.draw2d.geometry.Rectangle;

public class ActivationModel
extends MessageAcceptableModel {
    private static final long serialVersionUID = -2621679091279222643L;
    public static final String P_SOURCE_CONNECTION = "_source_connection";
    public static final String P_TARGET_CONNECTION = "_target_connection";
    public static final String P_CHILDREN = "_children";
    public static final int DEFAULT_WIDTH = 10;
    public static final int DEFAULT_HEIGHT = 20;
    private ActivationModel owner;
    private LifeLineModel ownerLine;
    private boolean movable = true;

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean movable) {
        this.movable = movable;
    }

    public void addActivation(ActivationModel model) {
        this.addChild(model);
        this.ownerLine.getOwner().getRoot().addActivation(model);
        model.setOwner(this);
        model.setOwnerLine(this.ownerLine);
        this.firePropertyChange(P_CHILDREN, null, model);
    }

    public void removeActivation(ActivationModel model) {
        this.removeChild(model);
        this.ownerLine.getOwner().getRoot().removeActivation(model);
    }

    public void setOwner(ActivationModel owner) {
        this.owner = owner;
    }

    public void setOwnerLine(LifeLineModel lineModel) {
        this.ownerLine = lineModel;
    }

    public LifeLineModel getOwnerLine() {
        return this.ownerLine;
    }

    @Override
    public ActivationModel getOwner() {
        return this.owner;
    }

    public InteractionModel getRoot() {
        return this.ownerLine.getOwner().getRoot();
    }

    @Override
    public void setConstraint(Rectangle constraint) {
        Rectangle old = this.getConstraint();
        if (old != null) {
            List<SyncMessageModel> targetConnection = this.getSyncTargetConnection();
            for (SyncMessageModel element : targetConnection) {
                ActivationModel source = (ActivationModel)element.getSource();
                if (constraint.y < source.getConstraint().y) {
                    constraint.y = source.getConstraint().y;
                }
                if (!element.isRecursive() || constraint.y >= source.getConstraint().y + 20) continue;
                constraint.y = source.getConstraint().y + 20;
            }
            Rectangle delta = new Rectangle();
            delta.x = constraint.x - old.x;
            delta.y = constraint.y - old.y;
            delta.width = constraint.width - old.width;
            delta.height = constraint.height - old.height;
            List<SyncMessageModel> list = this.getSyncSourceConnection();
            for (SyncMessageModel element : list) {
                element.updateCallee(delta);
            }
        }
        super.setConstraint(constraint);
        this.computeCaller();
    }

    public void adjustLocation(Rectangle delta) {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            rectangle.translate(delta.getLocation());
            rectangle.translate(delta.width / 2, 0);
            this.setConstraint(rectangle);
        }
        for (ActivationModel activationModel : this.getChildren()) {
            activationModel.adjustLocation(delta);
        }
    }

    public void computeSize() {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            rectangle.height = this.getChildrenSize() - rectangle.y;
            super.setConstraint(rectangle);
            this.computeOwner();
        }
    }

    private int getChildrenSize() {
        int max = this.getConstraint().y + 20;
        for (ActivationModel activationModel : this.getChildren()) {
            int cmax = activationModel.getConstraint().y + activationModel.getConstraint().height;
            if (max >= cmax) continue;
            max = cmax;
        }
        int callee = this.getCalleeSize();
        if (max > callee) {
            return max + 10;
        }
        return callee;
    }

    public void computeOwner() {
        if (this.owner != null) {
            this.owner.computeSize();
        } else if (this.ownerLine != null) {
            this.ownerLine.computeSize();
        }
    }

    @Override
    public void computeCaller() {
        List<AbstractUMLConnectionModel> connections;
        int size = this.getCalleeSize();
        Rectangle rectangle = this.getConstraint().getCopy();
        rectangle.height = size - rectangle.y;
        super.setConstraint(rectangle);
        List<SyncMessageModel> list = this.getSyncTargetConnection();
        for (SyncMessageModel element : list) {
            element.updateCaller(size);
        }
        if (!this.movable && !(connections = this.getOwnerLine().getOwner().getModelTargetConnections()).isEmpty()) {
            SyncMessageModel model = (SyncMessageModel)connections.get(0);
            model.updateCaller(size);
        }
    }

    @Override
    public void computeCaller(int size) {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            List<AbstractUMLConnectionModel> connections;
            int max = size;
            int calleeSize = this.getCalleeSize();
            if (size < calleeSize) {
                max = calleeSize;
            }
            rectangle.height = max - rectangle.y;
            super.setConstraint(rectangle);
            List<SyncMessageModel> list = this.getSyncTargetConnection();
            for (SyncMessageModel element : list) {
                element.updateCaller(max);
            }
            if (!this.movable && !(connections = this.getOwnerLine().getOwner().getModelTargetConnections()).isEmpty()) {
                SyncMessageModel model = (SyncMessageModel)connections.get(0);
                model.updateCaller(size);
            }
        }
    }

    @Override
    public void updateLocation(Rectangle delta) {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            rectangle.translate(0, delta.getLocation().y);
            super.setConstraint(rectangle);
        }
        List<SyncMessageModel> list = this.getSyncSourceConnection();
        for (SyncMessageModel element : list) {
            element.updateCallee(delta);
        }
    }

    public List<SyncMessageModel> getSyncSourceConnection() {
        List<AbstractUMLConnectionModel> modelSourceConnections = this.getModelSourceConnections();
        ArrayList<SyncMessageModel> rv = new ArrayList<SyncMessageModel>();
        for (AbstractUMLConnectionModel element : modelSourceConnections) {
            if (!(element instanceof SyncMessageModel)) continue;
            rv.add((SyncMessageModel)element);
        }
        return rv;
    }

    public List<SyncMessageModel> getSyncTargetConnection() {
        List<AbstractUMLConnectionModel> modelTargetConnections = this.getModelTargetConnections();
        ArrayList<SyncMessageModel> rv = new ArrayList<SyncMessageModel>();
        for (AbstractUMLConnectionModel element : modelTargetConnections) {
            if (!(element instanceof SyncMessageModel)) continue;
            rv.add((SyncMessageModel)element);
        }
        return rv;
    }

    public int getNestLevel() {
        if (this.owner == null) {
            return 1;
        }
        return this.owner.getNestLevel() + 1;
    }

    @Override
    public int getCalleeSize() {
        int max = this.getConstraint().y + 20;
        List<SyncMessageModel> connection = this.getSyncSourceConnection();
        for (SyncMessageModel element : connection) {
            int size = element.getCalleeSize();
            if (max >= size) continue;
            max = size;
        }
        return max + 10;
    }
}

