/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.model.TypeEntityModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import net.java.amateras.uml.sequencediagram.model.MessageAcceptableModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;
import net.java.amateras.uml.sequencediagram.property.TypePropertyDescriptor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class InstanceModel
extends MessageAcceptableModel
implements EntityModel {
    private static final long serialVersionUID = -4005555308028745846L;
    public static final String P_NAME = "_instance_name";
    public static final String P_TYPE = "_type";
    public static final int DEFAULT_LOCATION = 20;
    private String name = "";
    private TypeEntityModel type;
    private static int number = 1;
    private LifeLineModel lifeLine;
    private InteractionModel root;
    private SyncMessageModel creator;
    private Rectangle oldRectangle;
    private ActivationModel active;

    public ActivationModel getActive() {
        return this.active;
    }

    public void setActive(ActivationModel active) {
        this.active = active;
    }

    public InstanceModel() {
        this.setName("Instance" + number);
        ++number;
        this.lifeLine = new LifeLineModel(this);
        this.copyPresentation(this.lifeLine);
        this.addChild(this.lifeLine);
    }

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(P_NAME, oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setType(TypeEntityModel type) {
        TypeEntityModel old = this.type;
        this.type = type;
        this.firePropertyChange(P_TYPE, old, type);
    }

    public TypeEntityModel getType() {
        return this.type;
    }

    public LifeLineModel getModel() {
        return this.lifeLine;
    }

    public void setRoot(InteractionModel root) {
        this.root = root;
        root.addLifeLine(this.getModel());
    }

    public InteractionModel getRoot() {
        return this.root;
    }

    public SyncMessageModel getCreator() {
        return this.creator;
    }

    public void setCreator(SyncMessageModel creator) {
        this.creator = creator;
    }

    @Override
    public void setConstraint(Rectangle constraint) {
        List<AbstractUMLConnectionModel> connections;
        Rectangle old = this.getConstraint();
        if (old != null) {
            connections = this.getModelTargetConnections();
            for (SyncMessageModel syncMessageModel : connections) {
                if (syncMessageModel.getSource().getConstraint().y <= constraint.y) continue;
                constraint.y = syncMessageModel.getSource().getConstraint().y;
            }
            Rectangle delta = new Rectangle();
            delta.x = constraint.x - old.x;
            delta.y = constraint.y - old.y;
            delta.width = constraint.width - old.width;
            delta.height = 0;
            if (this.active != null) {
                Rectangle rectangle = this.active.getConstraint().getCopy();
                rectangle.translate(0, delta.y);
                this.active.setConstraint(rectangle);
            }
            this.lifeLine.adjustLocation(delta);
        }
        super.setConstraint(constraint);
        connections = this.getModelTargetConnections();
        for (SyncMessageModel syncMessageModel : connections) {
            syncMessageModel.updateCaller(this.getConstraint().y + this.getConstraint().height + 20);
        }
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_NAME, UMLPlugin.getDefault().getResourceString("property.name")), new TypePropertyDescriptor(P_TYPE, UMLPlugin.getDefault().getResourceString("property.type")), new ColorPropertyDescriptor((Object)"_background", UMLPlugin.getDefault().getResourceString("property.background"))};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(P_NAME)) {
            return this.getName();
        }
        if (id.equals(P_TYPE)) {
            return this.getType();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public boolean isPropertySet(Object id) {
        if (id.equals(P_NAME)) {
            return true;
        }
        if (id.equals(P_TYPE)) {
            return true;
        }
        return super.isPropertySet(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(P_NAME)) {
            this.setName((String)value);
        } else if (id.equals(P_TYPE)) {
            this.setType((TypeEntityModel)value);
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public void updateLocation(Rectangle delta) {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            rectangle = rectangle.getCopy();
            rectangle.translate(0, delta.y);
            super.setConstraint(rectangle);
            if (this.active != null) {
                Rectangle ac = this.active.getConstraint().getCopy();
                ac.translate(0, delta.y);
                this.active.setConstraint(ac);
            }
            this.lifeLine.adjustLocationWithNoEffect(delta);
        }
    }

    @Override
    public void computeCaller(int size) {
        if (this.active != null) {
            this.active.computeCaller(size);
        }
    }

    @Override
    public int getCalleeSize() {
        int size;
        if (this.active != null && (size = this.active.getCalleeSize()) > this.getConstraint().y + this.getConstraint().height + 40) {
            return size;
        }
        return this.getConstraint().y + this.getConstraint().height + 40;
    }

    @Override
    public ActivationModel getOwner() {
        return null;
    }

    public int computeChild() {
        return 0;
    }

    @Override
    public void computeCaller() {
        if (this.getModelTargetConnections().isEmpty()) {
            this.oldRectangle = this.getConstraint().getCopy();
            Rectangle rectangle = this.getConstraint().getCopy();
            rectangle.y = 20;
            this.setConstraint(rectangle);
        } else {
            this.setConstraint(this.oldRectangle);
            int size = this.getCalleeSize();
            SyncMessageModel element = (SyncMessageModel)this.getModelTargetConnections().get(0);
            element.updateCaller(size);
        }
    }
}

