/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.ArrayList;
import java.util.List;
import net.java.amateras.uml.model.AbstractUMLModel;
import net.java.amateras.uml.model.NoteModel;
import net.java.amateras.uml.model.RootModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.FragmentModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.model.LifeLineModel;
import org.eclipse.draw2d.geometry.Rectangle;

public class InteractionModel
extends RootModel {
    private static final long serialVersionUID = -5710259687258670340L;
    public static final String P_INSTANCE = "_children_instance";
    public static final String P_ACTIVATION = "_children_activation";
    public static final String P_FRAGMENT = "_children_fragment";
    public static final String P_LIFELINE = "_children_lifeline";
    private List<InstanceModel> instances = new ArrayList<InstanceModel>();
    private List<ActivationModel> activations = new ArrayList<ActivationModel>();
    private List<FragmentModel> fragments = new ArrayList<FragmentModel>();
    private List<LifeLineModel> lifelines = new ArrayList<LifeLineModel>();

    public void addInstance(InstanceModel child) {
        child.setRoot(this);
        this.instances.add(child);
        this.addChild(child);
        this.firePropertyChange(P_INSTANCE, null, child);
    }

    public List<InstanceModel> getInstances() {
        return this.instances;
    }

    public void removeInstance(InstanceModel obj) {
        this.instances.remove(obj);
        this.removeChild(obj);
        this.firePropertyChange(P_INSTANCE, obj, null);
        this.removeLifeLine(obj.getModel());
    }

    public void addActivation(ActivationModel child) {
        this.activations.add(child);
        this.addChild(child);
        this.firePropertyChange(P_ACTIVATION, null, child);
    }

    public List<ActivationModel> getActivations() {
        return this.activations;
    }

    public void removeActivation(ActivationModel obj) {
        this.activations.remove(obj);
        this.removeChild(obj);
        this.firePropertyChange(P_ACTIVATION, obj, null);
        for (ActivationModel activationModel : obj.getChildren()) {
            this.removeActivation(activationModel);
        }
        obj.getModelSourceConnections().clear();
        obj.getModelTargetConnections().clear();
    }

    public void addFragment(FragmentModel child) {
        this.fragments.add(child);
        this.addChild(child);
        this.firePropertyChange(P_FRAGMENT, null, child);
    }

    public List<FragmentModel> getFragments() {
        return this.fragments;
    }

    public void removeFragment(FragmentModel obj) {
        this.fragments.remove(obj);
        this.removeChild(obj);
        this.firePropertyChange(P_FRAGMENT, obj, null);
    }

    public void addLifeLine(LifeLineModel child) {
        this.addChild(child);
        this.lifelines.add(child);
        this.firePropertyChange(P_LIFELINE, null, child);
        this.adjustLifeLine();
    }

    public List<LifeLineModel> getLifeLines() {
        return this.lifelines;
    }

    public void removeLifeLine(LifeLineModel obj) {
        this.removeChild(obj);
        this.lifelines.remove(obj);
        this.firePropertyChange(P_LIFELINE, obj, null);
        for (ActivationModel activationModel : obj.getChildren()) {
            this.removeActivation(activationModel);
        }
    }

    public void addUMLModel(AbstractUMLModel model) {
        if (model instanceof InstanceModel) {
            this.addInstance((InstanceModel)model);
        } else if (model instanceof ActivationModel) {
            this.addActivation((ActivationModel)model);
        } else if (model instanceof FragmentModel) {
            this.addFragment((FragmentModel)model);
        } else if (model instanceof LifeLineModel) {
            this.addLifeLine((LifeLineModel)model);
        } else {
            super.addChild(model);
        }
    }

    public void removeUMLModel(AbstractUMLModel model) {
        if (this.instances.contains(model)) {
            this.removeInstance((InstanceModel)model);
        }
        if (this.activations.contains(model)) {
            this.removeActivation((ActivationModel)model);
        }
        if (this.fragments.contains(model)) {
            this.removeFragment((FragmentModel)model);
        }
        if (this.lifelines.contains(model)) {
            this.removeLifeLine((LifeLineModel)model);
        }
    }

    public void adjustLifeLine() {
        int max = 220;
        for (LifeLineModel element : this.lifelines) {
            for (ActivationModel activationModel : element.getChildren()) {
                int current = activationModel.getConstraint().y + activationModel.getConstraint().height + 30;
                if (current <= max) continue;
                max = current;
            }
        }
        for (LifeLineModel element : this.lifelines) {
            Rectangle rectangle = element.getConstraint();
            rectangle.height = max - rectangle.y;
            element.setConstraint(rectangle);
        }
    }

    public List<Object> getNotes() {
        ArrayList<Object> rv = new ArrayList<Object>();
        for (AbstractUMLModel element : this.getChildren()) {
            if (!(element instanceof NoteModel)) continue;
            rv.add(element);
        }
        return rv;
    }
}

