/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class LifeLineModel
extends AbstractUMLEntityModel {
    private static final long serialVersionUID = 7837713150143716280L;
    public static final String P_CHILDREN = "_children";
    public static final int DEFAULT_HEIGHT = 200;
    public static final String P_ADJUST = "_adjust";
    private final InstanceModel owner;
    private Rectangle old;

    public LifeLineModel(InstanceModel owner) {
        this.owner = owner;
    }

    public InstanceModel getOwner() {
        return this.owner;
    }

    public void addActivation(ActivationModel model) {
        this.addChild(model);
        this.owner.getRoot().addActivation(model);
        model.setOwnerLine(this);
        this.firePropertyChange(P_CHILDREN, null, model);
    }

    public void removeActivation(ActivationModel model) {
        this.removeChild(model);
        this.owner.getRoot().removeActivation(model);
        model.setOwnerLine(null);
    }

    public void adjustLocation(Rectangle delta) {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            rectangle.translate(delta.getLocation());
            rectangle.translate(delta.width / 2, 0);
            this.setConstraint(rectangle);
        }
        delta.y = 0;
        for (ActivationModel activationModel : this.getChildren()) {
            activationModel.adjustLocation(delta);
        }
    }

    public void adjustLocationWithNoEffect(Rectangle delta) {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            rectangle.translate(delta.getLocation());
            rectangle.translate(delta.width / 2, 0);
            this.setConstraint(rectangle);
        }
    }

    public void computeSize() {
        Rectangle rectangle = this.getConstraint();
        if (rectangle != null) {
            int max = 0;
            for (ActivationModel activationModel : this.getChildren()) {
                int cmax = activationModel.getConstraint().y + activationModel.getConstraint().height;
                if (max >= cmax) continue;
                max = cmax;
            }
            if (max > 200) {
                this.old = rectangle.getCopy();
                rectangle.height = max - rectangle.y + 10;
                this.setConstraint(rectangle);
            }
        }
    }

    public void undoSize() {
        if (this.old != null) {
            this.setConstraint(this.old);
        }
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[0];
    }
}

