/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.Collections;
import java.util.List;
import net.java.amateras.uml.UMLPlugin;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.model.AbstractUMLEntityModel;
import net.java.amateras.uml.model.EntityModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.InstanceModel;
import net.java.amateras.uml.sequencediagram.property.MessagePropertyDescriptor;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MessageModel
extends AbstractUMLConnectionModel
implements EntityModel {
    private static final long serialVersionUID = -8612461909422488988L;
    public static final String P_NAME = "_instance_name";
    public static final String P_DIRECTION = "_direction";
    private String name;
    private boolean direction;

    @Override
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(P_NAME, oldName, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private EntityModel getType() {
        AbstractUMLEntityModel model = this.getTarget();
        if (model instanceof ActivationModel) {
            ActivationModel activationModel = (ActivationModel)model;
            InstanceModel owner = activationModel.getOwnerLine().getOwner();
            return owner.getType();
        }
        return null;
    }

    public List<?> getProporsal() {
        EntityModel model = this.getType();
        if (model instanceof AbstractUMLEntityModel) {
            AbstractUMLEntityModel entityModel = (AbstractUMLEntityModel)((Object)model);
            return entityModel.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        MessagePropertyDescriptor descriptor = new MessagePropertyDescriptor(P_NAME, UMLPlugin.getDefault().getResourceString("property.name"));
        descriptor.setUMLModels(this.getProporsal());
        return new IPropertyDescriptor[]{descriptor, new ColorPropertyDescriptor((Object)"_foreground", UMLPlugin.getDefault().getResourceString("property.foreground"))};
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(P_NAME)) {
            return this.getName();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public boolean isPropertySet(Object id) {
        if (id.equals(P_NAME)) {
            return true;
        }
        return super.isPropertySet(id);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(P_NAME)) {
            this.setName((String)value);
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public void attachTarget() {
        super.attachTarget();
    }

    public void calcDirection() {
        if (this.getSource() != null && this.getTarget() != null) {
            this.setDirection(this.getSource().getConstraint().x < this.getTarget().getConstraint().x);
        }
    }

    public boolean isDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
        this.firePropertyChange(P_DIRECTION, null, new Boolean(direction));
    }
}

