/*
 * Decompiled with CFR 0.152.
 */
package net.java.amateras.uml.sequencediagram.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.java.amateras.uml.model.AbstractUMLConnectionModel;
import net.java.amateras.uml.sequencediagram.model.ActivationModel;
import net.java.amateras.uml.sequencediagram.model.InteractionModel;
import net.java.amateras.uml.sequencediagram.model.MessageModel;
import net.java.amateras.uml.sequencediagram.model.SyncMessageModel;

public class MessageOrderUtil {
    public static void computeMessageOrders(InteractionModel model) {
        List<ActivationModel> activations = model.getActivations();
        ArrayList<SyncMessageModel> messages = new ArrayList<SyncMessageModel>();
        for (ActivationModel element : activations) {
            messages.addAll(element.getSyncSourceConnection());
        }
        Collections.sort(messages, new MessageOrderComparator());
        int index = 1;
        for (SyncMessageModel element : messages) {
            element.setOrder(index);
            ++index;
        }
        MessageOrderUtil.computeMessageDirection(model);
    }

    private static void computeMessageDirection(InteractionModel model) {
        List<ActivationModel> activations = model.getActivations();
        ArrayList<AbstractUMLConnectionModel> messages = new ArrayList<AbstractUMLConnectionModel>();
        for (ActivationModel activationModel : activations) {
            messages.addAll(activationModel.getModelSourceConnections());
        }
        for (MessageModel messageModel : messages) {
            messageModel.calcDirection();
        }
    }

    static class MessageOrderComparator
    implements Comparator<Object> {
        MessageOrderComparator() {
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            SyncMessageModel msgSource = (SyncMessageModel)arg0;
            SyncMessageModel msgTarget = (SyncMessageModel)arg1;
            int source = msgSource.getTarget().getConstraint().y;
            int target = msgTarget.getTarget().getConstraint().y;
            if (source == target) {
                return 0;
            }
            if (source < target) {
                return -1;
            }
            return 1;
        }
    }
}

